# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.common_model_scope_api import CommonModelScopeApi
from ...types.individual_common_model_scope_deserializer_request import IndividualCommonModelScopeDeserializerRequest
from .raw_client import AsyncRawScopesClient, RawScopesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ScopesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawScopesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawScopesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawScopesClient
        """
        return self._raw_client

    def default_scopes_retrieve(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CommonModelScopeApi:
        """
        Get the default permissions for Merge Common Models and fields across all Linked Accounts of a given category. [Learn more](https://help.merge.dev/en/articles/5950052-common-model-and-field-scopes).

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommonModelScopeApi


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.accounting.scopes.default_scopes_retrieve()
        """
        _response = self._raw_client.default_scopes_retrieve(request_options=request_options)
        return _response.data

    def linked_account_scopes_retrieve(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CommonModelScopeApi:
        """
        Get all available permissions for Merge Common Models and fields for a single Linked Account. [Learn more](https://help.merge.dev/en/articles/5950052-common-model-and-field-scopes).

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommonModelScopeApi


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.accounting.scopes.linked_account_scopes_retrieve()
        """
        _response = self._raw_client.linked_account_scopes_retrieve(request_options=request_options)
        return _response.data

    def linked_account_scopes_create(
        self,
        *,
        common_models: typing.Sequence[IndividualCommonModelScopeDeserializerRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CommonModelScopeApi:
        """
        Update permissions for any Common Model or field for a single Linked Account. Any Scopes not set in this POST request will inherit the default Scopes. [Learn more](https://help.merge.dev/en/articles/5950052-common-model-and-field-scopes)

        Parameters
        ----------
        common_models : typing.Sequence[IndividualCommonModelScopeDeserializerRequest]
            The common models you want to update the scopes for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommonModelScopeApi


        Examples
        --------
        from merge import Merge
        from merge.resources.accounting import (
            FieldPermissionDeserializerRequest,
            IndividualCommonModelScopeDeserializerRequest,
            ModelPermissionDeserializerRequest,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.accounting.scopes.linked_account_scopes_create(
            common_models=[
                IndividualCommonModelScopeDeserializerRequest(
                    model_name="Employee",
                    model_permissions={
                        "READ": ModelPermissionDeserializerRequest(
                            is_enabled=True,
                        ),
                        "WRITE": ModelPermissionDeserializerRequest(
                            is_enabled=False,
                        ),
                    },
                    field_permissions=FieldPermissionDeserializerRequest(
                        enabled_fields=["avatar", "home_location"],
                        disabled_fields=["work_location"],
                    ),
                ),
                IndividualCommonModelScopeDeserializerRequest(
                    model_name="Benefit",
                    model_permissions={
                        "WRITE": ModelPermissionDeserializerRequest(
                            is_enabled=False,
                        )
                    },
                ),
            ],
        )
        """
        _response = self._raw_client.linked_account_scopes_create(
            common_models=common_models, request_options=request_options
        )
        return _response.data


class AsyncScopesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawScopesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawScopesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawScopesClient
        """
        return self._raw_client

    async def default_scopes_retrieve(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CommonModelScopeApi:
        """
        Get the default permissions for Merge Common Models and fields across all Linked Accounts of a given category. [Learn more](https://help.merge.dev/en/articles/5950052-common-model-and-field-scopes).

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommonModelScopeApi


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.accounting.scopes.default_scopes_retrieve()


        asyncio.run(main())
        """
        _response = await self._raw_client.default_scopes_retrieve(request_options=request_options)
        return _response.data

    async def linked_account_scopes_retrieve(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CommonModelScopeApi:
        """
        Get all available permissions for Merge Common Models and fields for a single Linked Account. [Learn more](https://help.merge.dev/en/articles/5950052-common-model-and-field-scopes).

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommonModelScopeApi


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.accounting.scopes.linked_account_scopes_retrieve()


        asyncio.run(main())
        """
        _response = await self._raw_client.linked_account_scopes_retrieve(request_options=request_options)
        return _response.data

    async def linked_account_scopes_create(
        self,
        *,
        common_models: typing.Sequence[IndividualCommonModelScopeDeserializerRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CommonModelScopeApi:
        """
        Update permissions for any Common Model or field for a single Linked Account. Any Scopes not set in this POST request will inherit the default Scopes. [Learn more](https://help.merge.dev/en/articles/5950052-common-model-and-field-scopes)

        Parameters
        ----------
        common_models : typing.Sequence[IndividualCommonModelScopeDeserializerRequest]
            The common models you want to update the scopes for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommonModelScopeApi


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.accounting import (
            FieldPermissionDeserializerRequest,
            IndividualCommonModelScopeDeserializerRequest,
            ModelPermissionDeserializerRequest,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.accounting.scopes.linked_account_scopes_create(
                common_models=[
                    IndividualCommonModelScopeDeserializerRequest(
                        model_name="Employee",
                        model_permissions={
                            "READ": ModelPermissionDeserializerRequest(
                                is_enabled=True,
                            ),
                            "WRITE": ModelPermissionDeserializerRequest(
                                is_enabled=False,
                            ),
                        },
                        field_permissions=FieldPermissionDeserializerRequest(
                            enabled_fields=["avatar", "home_location"],
                            disabled_fields=["work_location"],
                        ),
                    ),
                    IndividualCommonModelScopeDeserializerRequest(
                        model_name="Benefit",
                        model_permissions={
                            "WRITE": ModelPermissionDeserializerRequest(
                                is_enabled=False,
                            )
                        },
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.linked_account_scopes_create(
            common_models=common_models, request_options=request_options
        )
        return _response.data
