# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .accounting_period_status import AccountingPeriodStatus
from .remote_data import RemoteData


class AccountingPeriod(UncheckedBaseModel):
    """
    # The AccountingPeriod Object
    ### Description
    The `AccountingPeriod` object is used to define a period of time in which events occurred.

    ### Usage Example
    Common models like `Invoice` and `Transaction` will have `AccountingPeriod` objects which will denote when they occurred.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the accounting period.
    """

    status: typing.Optional[AccountingPeriodStatus] = None
    start_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Beginning date of the period
    """

    end_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    End date of the period
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
