# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .credit_note_apply_line_for_credit_note_request_invoice import CreditNoteApplyLineForCreditNoteRequestInvoice


class CreditNoteApplyLineForCreditNoteRequest(UncheckedBaseModel):
    """
    # The CreditNoteApplyLine Object
    ### Description
    The `CreditNoteApplyLine` is attached to the CreditNote model.

    ### Usage Example
    Fetch from the `GET CreditNote` endpoint and view the invoice's applied to lines.
    """

    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    invoice: typing.Optional[CreditNoteApplyLineForCreditNoteRequestInvoice] = None
    applied_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Date that the credit note is applied to the invoice.
    """

    applied_amount: typing.Optional[str] = pydantic.Field(default=None)
    """
    The amount of the Credit Note applied to the invoice.
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .credit_note import CreditNote  # noqa: E402, F401, I001
from .credit_note_apply_line_for_credit_note import CreditNoteApplyLineForCreditNote  # noqa: E402, F401, I001
from .credit_note_apply_line_for_invoice import CreditNoteApplyLineForInvoice  # noqa: E402, F401, I001
from .invoice import Invoice  # noqa: E402, F401, I001
from .vendor_credit import VendorCredit  # noqa: E402, F401, I001
from .vendor_credit_apply_line_for_invoice import VendorCreditApplyLineForInvoice  # noqa: E402, F401, I001
from .vendor_credit_apply_line_for_vendor_credit import VendorCreditApplyLineForVendorCredit  # noqa: E402, F401, I001

update_forward_refs(CreditNoteApplyLineForCreditNoteRequest)
