# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .credit_note_line_item_company import CreditNoteLineItemCompany
from .credit_note_line_item_contact import CreditNoteLineItemContact
from .credit_note_line_item_item import CreditNoteLineItemItem
from .credit_note_line_item_project import CreditNoteLineItemProject


class CreditNoteLineItem(UncheckedBaseModel):
    """
    # The CreditNoteLineItem Object
    ### Description
    The `CreditNoteLineItem` object is used to represent a credit note's line items.

    ### Usage Example
    Fetch from the `GET CreditNote` endpoint and view the credit note's line items.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    item: typing.Optional[CreditNoteLineItemItem] = None
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's name.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the item that is owed.
    """

    quantity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's quantity.
    """

    memo: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's memo.
    """

    unit_price: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's unit price.
    """

    tax_rate: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tax rate that applies to this line item.
    """

    total_line_amount: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's total.
    """

    tracking_category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's associated tracking category.
    """

    tracking_categories: typing.Optional[typing.List[typing.Optional[str]]] = pydantic.Field(default=None)
    """
    The credit note line item's associated tracking categories.
    """

    account: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's account.
    """

    company: typing.Optional[CreditNoteLineItemCompany] = pydantic.Field(default=None)
    """
    The company the credit note belongs to.
    """

    contact: typing.Optional[CreditNoteLineItemContact] = pydantic.Field(default=None)
    """
    The credit note's contact.
    """

    project: typing.Optional[CreditNoteLineItemProject] = None
    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
