# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .general_ledger_transaction_accounting_period import GeneralLedgerTransactionAccountingPeriod
from .general_ledger_transaction_company import GeneralLedgerTransactionCompany
from .general_ledger_transaction_general_ledger_transaction_lines_item import (
    GeneralLedgerTransactionGeneralLedgerTransactionLinesItem,
)
from .general_ledger_transaction_tracking_categories_item import GeneralLedgerTransactionTrackingCategoriesItem
from .general_ledger_transaction_underlying_transaction_type import GeneralLedgerTransactionUnderlyingTransactionType
from .remote_data import RemoteData


class GeneralLedgerTransaction(UncheckedBaseModel):
    """
    # The GeneralLedgerTransaction Object
    ### Description
    A General Ledger Entry is a record of a financial transaction that is posted to the general ledger, the central repository of a company’s financial data.

    The `GeneralLedgerTransaction` object is a singular endpoint to pull all transactions posted to a company’s general ledger. The transaction that generated the `GeneralLedgerTransaction` can be found by referencing the `underlying_transaction_type` and `underlying_transaction_remote_id` fields.

    The lines of a `GeneralLedgerTransaction` object will always have equal amounts of debits and credits.

    ### Usage Example
    Fetch from the `GET GeneralLedgerTransaction` endpoint and view a general ledger transaction.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    underlying_transaction_remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third party remote ID of the underlying transaction.
    """

    underlying_transaction_type: typing.Optional[GeneralLedgerTransactionUnderlyingTransactionType] = pydantic.Field(
        default=None
    )
    """
    The type of the underlying transaction.
    
    * `INVOICE` - INVOICE
    * `EXPENSE` - EXPENSE
    * `TRANSACTION` - TRANSACTION
    * `JOURNAL_ENTRY` - JOURNAL_ENTRY
    * `PAYMENT` - PAYMENT
    * `VENDOR_CREDIT` - VENDOR_CREDIT
    * `CREDIT_NOTE` - CREDIT_NOTE
    """

    accounting_period: typing.Optional[GeneralLedgerTransactionAccountingPeriod] = pydantic.Field(default=None)
    """
    The accounting period that the GeneralLedgerTransaction was generated in.
    """

    company: typing.Optional[GeneralLedgerTransactionCompany] = pydantic.Field(default=None)
    """
    The company the GeneralLedgerTransaction belongs to.
    """

    remote_updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's GeneralLedgerTransaction entry was updated.
    """

    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's GeneralLedgerTransaction entry was created.
    """

    tracking_categories: typing.Optional[
        typing.List[typing.Optional[GeneralLedgerTransactionTrackingCategoriesItem]]
    ] = None
    posting_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date that the transaction was posted to the general ledger.
    """

    general_ledger_transaction_lines: typing.Optional[
        typing.List[GeneralLedgerTransactionGeneralLedgerTransactionLinesItem]
    ] = pydantic.Field(default=None)
    """
    A list of “General Ledger Transaction Applied to Lines” objects.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
