# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .tax_component_component_type import TaxComponentComponentType


class TaxComponent(UncheckedBaseModel):
    """
    # The TaxRate Object
    ### Description
    The `TaxComponent` object is used to represent any sub-taxes that make up the `TaxRate`.

    ### Usage Example
    Fetch from the `LIST TaxRates` endpoint and view tax components relevant to a tax rate.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tax rate’s name.
    """

    rate: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tax component’s rate.
    """

    is_compound: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Returns True if the tax component is compound, False if not.
    """

    component_type: typing.Optional[TaxComponentComponentType] = pydantic.Field(default=None)
    """
    Returns PURCHASE if the tax component corresponds to a purchase tax or SALES if the tax component corresponds to a sales tax.
    
    * `SALES` - SALES
    * `PURCHASE` - PURCHASE
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
