# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .tracking_category_category_type import TrackingCategoryCategoryType
from .tracking_category_company import TrackingCategoryCompany
from .tracking_category_status import TrackingCategoryStatus


class TrackingCategory(UncheckedBaseModel):
    """
    # The TrackingCategory Object
    ### Description
    A `TrackingCategory` object represents a categorization method used to classify transactions within an accounting platform. They are often used to group records for reporting and analysis purposes. The most common types of `TrackingCategories` are Classes and Departments.

    ### Usage Example
    Fetch from the `GET TrackingCategory` endpoint and view a company's tracking category.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tracking category's name.
    """

    status: typing.Optional[TrackingCategoryStatus] = pydantic.Field(default=None)
    """
    The tracking category's status.
    
    * `ACTIVE` - ACTIVE
    * `ARCHIVED` - ARCHIVED
    """

    category_type: typing.Optional[TrackingCategoryCategoryType] = pydantic.Field(default=None)
    """
    The tracking category’s type.
    
    * `CLASS` - CLASS
    * `DEPARTMENT` - DEPARTMENT
    """

    parent_category: typing.Optional[str] = None
    company: typing.Optional[TrackingCategoryCompany] = pydantic.Field(default=None)
    """
    The company the GeneralLedgerTransaction belongs to.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
