# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class UnderlyingTransactionTypeEnum(str, enum.Enum):
    """
    * `INVOICE` - INVOICE
    * `EXPENSE` - EXPENSE
    * `TRANSACTION` - TRANSACTION
    * `JOURNAL_ENTRY` - JOURNAL_ENTRY
    * `PAYMENT` - PAYMENT
    * `VENDOR_CREDIT` - VENDOR_CREDIT
    * `CREDIT_NOTE` - CREDIT_NOTE
    """

    INVOICE = "INVOICE"
    EXPENSE = "EXPENSE"
    TRANSACTION = "TRANSACTION"
    JOURNAL_ENTRY = "JOURNAL_ENTRY"
    PAYMENT = "PAYMENT"
    VENDOR_CREDIT = "VENDOR_CREDIT"
    CREDIT_NOTE = "CREDIT_NOTE"

    def visit(
        self,
        invoice: typing.Callable[[], T_Result],
        expense: typing.Callable[[], T_Result],
        transaction: typing.Callable[[], T_Result],
        journal_entry: typing.Callable[[], T_Result],
        payment: typing.Callable[[], T_Result],
        vendor_credit: typing.Callable[[], T_Result],
        credit_note: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is UnderlyingTransactionTypeEnum.INVOICE:
            return invoice()
        if self is UnderlyingTransactionTypeEnum.EXPENSE:
            return expense()
        if self is UnderlyingTransactionTypeEnum.TRANSACTION:
            return transaction()
        if self is UnderlyingTransactionTypeEnum.JOURNAL_ENTRY:
            return journal_entry()
        if self is UnderlyingTransactionTypeEnum.PAYMENT:
            return payment()
        if self is UnderlyingTransactionTypeEnum.VENDOR_CREDIT:
            return vendor_credit()
        if self is UnderlyingTransactionTypeEnum.CREDIT_NOTE:
            return credit_note()
