# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .vendor_credit_line_request_account import VendorCreditLineRequestAccount
from .vendor_credit_line_request_contact import VendorCreditLineRequestContact
from .vendor_credit_line_request_project import VendorCreditLineRequestProject


class VendorCreditLineRequest(UncheckedBaseModel):
    """
    # The VendorCreditLine Object
    ### Description
    The `VendorCreditLine` object is used to represent a vendor credit's line items.

    ### Usage Example
    Fetch from the `GET VendorCredit` endpoint and view the vendor credit's line items.
    """

    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    net_amount: typing.Optional[float] = pydantic.Field(default=None)
    """
    The full value of the credit.
    """

    tracking_category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The line's associated tracking category.
    """

    tracking_categories: typing.Optional[typing.List[typing.Optional[str]]] = pydantic.Field(default=None)
    """
    The vendor credit line item's associated tracking categories.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The line's description.
    """

    account: typing.Optional[VendorCreditLineRequestAccount] = pydantic.Field(default=None)
    """
    The line's account.
    """

    company: typing.Optional[str] = pydantic.Field(default=None)
    """
    The company the line belongs to.
    """

    project: typing.Optional[VendorCreditLineRequestProject] = None
    contact: typing.Optional[VendorCreditLineRequestContact] = None
    tax_rate: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tax rate that applies to this line item.
    """

    exchange_rate: typing.Optional[str] = pydantic.Field(default=None)
    """
    The vendor credit line item's exchange rate.
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
