# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawAtsClient, RawAtsClient

if typing.TYPE_CHECKING:
    from .resources.account_details.client import AccountDetailsClient, AsyncAccountDetailsClient
    from .resources.account_token.client import AccountTokenClient, AsyncAccountTokenClient
    from .resources.activities.client import ActivitiesClient, AsyncActivitiesClient
    from .resources.applications.client import ApplicationsClient, AsyncApplicationsClient
    from .resources.async_passthrough.client import AsyncAsyncPassthroughClient
    from .resources.async_passthrough.client import (
        AsyncPassthroughClient as resources_ats_resources_async_passthrough_client_AsyncPassthroughClient,
    )
    from .resources.attachments.client import AsyncAttachmentsClient, AttachmentsClient
    from .resources.audit_trail.client import AsyncAuditTrailClient, AuditTrailClient
    from .resources.available_actions.client import AsyncAvailableActionsClient, AvailableActionsClient
    from .resources.candidates.client import AsyncCandidatesClient, CandidatesClient
    from .resources.delete_account.client import AsyncDeleteAccountClient, DeleteAccountClient
    from .resources.departments.client import AsyncDepartmentsClient, DepartmentsClient
    from .resources.eeocs.client import AsyncEeocsClient, EeocsClient
    from .resources.field_mapping.client import AsyncFieldMappingClient, FieldMappingClient
    from .resources.force_resync.client import AsyncForceResyncClient, ForceResyncClient
    from .resources.generate_key.client import AsyncGenerateKeyClient, GenerateKeyClient
    from .resources.interviews.client import AsyncInterviewsClient, InterviewsClient
    from .resources.issues.client import AsyncIssuesClient, IssuesClient
    from .resources.job_interview_stages.client import AsyncJobInterviewStagesClient, JobInterviewStagesClient
    from .resources.job_postings.client import AsyncJobPostingsClient, JobPostingsClient
    from .resources.jobs.client import AsyncJobsClient, JobsClient
    from .resources.link_token.client import AsyncLinkTokenClient, LinkTokenClient
    from .resources.linked_accounts.client import AsyncLinkedAccountsClient, LinkedAccountsClient
    from .resources.offers.client import AsyncOffersClient, OffersClient
    from .resources.offices.client import AsyncOfficesClient, OfficesClient
    from .resources.passthrough.client import (
        AsyncPassthroughClient as resources_ats_resources_passthrough_client_AsyncPassthroughClient,
    )
    from .resources.passthrough.client import PassthroughClient
    from .resources.regenerate_key.client import AsyncRegenerateKeyClient, RegenerateKeyClient
    from .resources.reject_reasons.client import AsyncRejectReasonsClient, RejectReasonsClient
    from .resources.scopes.client import AsyncScopesClient, ScopesClient
    from .resources.scorecards.client import AsyncScorecardsClient, ScorecardsClient
    from .resources.sync_status.client import AsyncSyncStatusClient, SyncStatusClient
    from .resources.tags.client import AsyncTagsClient, TagsClient
    from .resources.users.client import AsyncUsersClient, UsersClient
    from .resources.webhook_receivers.client import AsyncWebhookReceiversClient, WebhookReceiversClient


class AtsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAtsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._account_details: typing.Optional[AccountDetailsClient] = None
        self._account_token: typing.Optional[AccountTokenClient] = None
        self._activities: typing.Optional[ActivitiesClient] = None
        self._applications: typing.Optional[ApplicationsClient] = None
        self._async_passthrough: typing.Optional[
            resources_ats_resources_async_passthrough_client_AsyncPassthroughClient
        ] = None
        self._attachments: typing.Optional[AttachmentsClient] = None
        self._audit_trail: typing.Optional[AuditTrailClient] = None
        self._available_actions: typing.Optional[AvailableActionsClient] = None
        self._candidates: typing.Optional[CandidatesClient] = None
        self._scopes: typing.Optional[ScopesClient] = None
        self._delete_account: typing.Optional[DeleteAccountClient] = None
        self._departments: typing.Optional[DepartmentsClient] = None
        self._eeocs: typing.Optional[EeocsClient] = None
        self._field_mapping: typing.Optional[FieldMappingClient] = None
        self._generate_key: typing.Optional[GenerateKeyClient] = None
        self._interviews: typing.Optional[InterviewsClient] = None
        self._issues: typing.Optional[IssuesClient] = None
        self._job_interview_stages: typing.Optional[JobInterviewStagesClient] = None
        self._job_postings: typing.Optional[JobPostingsClient] = None
        self._jobs: typing.Optional[JobsClient] = None
        self._link_token: typing.Optional[LinkTokenClient] = None
        self._linked_accounts: typing.Optional[LinkedAccountsClient] = None
        self._offers: typing.Optional[OffersClient] = None
        self._offices: typing.Optional[OfficesClient] = None
        self._passthrough: typing.Optional[PassthroughClient] = None
        self._regenerate_key: typing.Optional[RegenerateKeyClient] = None
        self._reject_reasons: typing.Optional[RejectReasonsClient] = None
        self._scorecards: typing.Optional[ScorecardsClient] = None
        self._sync_status: typing.Optional[SyncStatusClient] = None
        self._force_resync: typing.Optional[ForceResyncClient] = None
        self._tags: typing.Optional[TagsClient] = None
        self._users: typing.Optional[UsersClient] = None
        self._webhook_receivers: typing.Optional[WebhookReceiversClient] = None

    @property
    def with_raw_response(self) -> RawAtsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAtsClient
        """
        return self._raw_client

    @property
    def account_details(self):
        if self._account_details is None:
            from .resources.account_details.client import AccountDetailsClient  # noqa: E402

            self._account_details = AccountDetailsClient(client_wrapper=self._client_wrapper)
        return self._account_details

    @property
    def account_token(self):
        if self._account_token is None:
            from .resources.account_token.client import AccountTokenClient  # noqa: E402

            self._account_token = AccountTokenClient(client_wrapper=self._client_wrapper)
        return self._account_token

    @property
    def activities(self):
        if self._activities is None:
            from .resources.activities.client import ActivitiesClient  # noqa: E402

            self._activities = ActivitiesClient(client_wrapper=self._client_wrapper)
        return self._activities

    @property
    def applications(self):
        if self._applications is None:
            from .resources.applications.client import ApplicationsClient  # noqa: E402

            self._applications = ApplicationsClient(client_wrapper=self._client_wrapper)
        return self._applications

    @property
    def async_passthrough(self):
        if self._async_passthrough is None:
            from .resources.async_passthrough.client import (
                AsyncPassthroughClient as resources_ats_resources_async_passthrough_client_AsyncPassthroughClient,  # noqa: E402
            )

            self._async_passthrough = resources_ats_resources_async_passthrough_client_AsyncPassthroughClient(
                client_wrapper=self._client_wrapper
            )
        return self._async_passthrough

    @property
    def attachments(self):
        if self._attachments is None:
            from .resources.attachments.client import AttachmentsClient  # noqa: E402

            self._attachments = AttachmentsClient(client_wrapper=self._client_wrapper)
        return self._attachments

    @property
    def audit_trail(self):
        if self._audit_trail is None:
            from .resources.audit_trail.client import AuditTrailClient  # noqa: E402

            self._audit_trail = AuditTrailClient(client_wrapper=self._client_wrapper)
        return self._audit_trail

    @property
    def available_actions(self):
        if self._available_actions is None:
            from .resources.available_actions.client import AvailableActionsClient  # noqa: E402

            self._available_actions = AvailableActionsClient(client_wrapper=self._client_wrapper)
        return self._available_actions

    @property
    def candidates(self):
        if self._candidates is None:
            from .resources.candidates.client import CandidatesClient  # noqa: E402

            self._candidates = CandidatesClient(client_wrapper=self._client_wrapper)
        return self._candidates

    @property
    def scopes(self):
        if self._scopes is None:
            from .resources.scopes.client import ScopesClient  # noqa: E402

            self._scopes = ScopesClient(client_wrapper=self._client_wrapper)
        return self._scopes

    @property
    def delete_account(self):
        if self._delete_account is None:
            from .resources.delete_account.client import DeleteAccountClient  # noqa: E402

            self._delete_account = DeleteAccountClient(client_wrapper=self._client_wrapper)
        return self._delete_account

    @property
    def departments(self):
        if self._departments is None:
            from .resources.departments.client import DepartmentsClient  # noqa: E402

            self._departments = DepartmentsClient(client_wrapper=self._client_wrapper)
        return self._departments

    @property
    def eeocs(self):
        if self._eeocs is None:
            from .resources.eeocs.client import EeocsClient  # noqa: E402

            self._eeocs = EeocsClient(client_wrapper=self._client_wrapper)
        return self._eeocs

    @property
    def field_mapping(self):
        if self._field_mapping is None:
            from .resources.field_mapping.client import FieldMappingClient  # noqa: E402

            self._field_mapping = FieldMappingClient(client_wrapper=self._client_wrapper)
        return self._field_mapping

    @property
    def generate_key(self):
        if self._generate_key is None:
            from .resources.generate_key.client import GenerateKeyClient  # noqa: E402

            self._generate_key = GenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._generate_key

    @property
    def interviews(self):
        if self._interviews is None:
            from .resources.interviews.client import InterviewsClient  # noqa: E402

            self._interviews = InterviewsClient(client_wrapper=self._client_wrapper)
        return self._interviews

    @property
    def issues(self):
        if self._issues is None:
            from .resources.issues.client import IssuesClient  # noqa: E402

            self._issues = IssuesClient(client_wrapper=self._client_wrapper)
        return self._issues

    @property
    def job_interview_stages(self):
        if self._job_interview_stages is None:
            from .resources.job_interview_stages.client import JobInterviewStagesClient  # noqa: E402

            self._job_interview_stages = JobInterviewStagesClient(client_wrapper=self._client_wrapper)
        return self._job_interview_stages

    @property
    def job_postings(self):
        if self._job_postings is None:
            from .resources.job_postings.client import JobPostingsClient  # noqa: E402

            self._job_postings = JobPostingsClient(client_wrapper=self._client_wrapper)
        return self._job_postings

    @property
    def jobs(self):
        if self._jobs is None:
            from .resources.jobs.client import JobsClient  # noqa: E402

            self._jobs = JobsClient(client_wrapper=self._client_wrapper)
        return self._jobs

    @property
    def link_token(self):
        if self._link_token is None:
            from .resources.link_token.client import LinkTokenClient  # noqa: E402

            self._link_token = LinkTokenClient(client_wrapper=self._client_wrapper)
        return self._link_token

    @property
    def linked_accounts(self):
        if self._linked_accounts is None:
            from .resources.linked_accounts.client import LinkedAccountsClient  # noqa: E402

            self._linked_accounts = LinkedAccountsClient(client_wrapper=self._client_wrapper)
        return self._linked_accounts

    @property
    def offers(self):
        if self._offers is None:
            from .resources.offers.client import OffersClient  # noqa: E402

            self._offers = OffersClient(client_wrapper=self._client_wrapper)
        return self._offers

    @property
    def offices(self):
        if self._offices is None:
            from .resources.offices.client import OfficesClient  # noqa: E402

            self._offices = OfficesClient(client_wrapper=self._client_wrapper)
        return self._offices

    @property
    def passthrough(self):
        if self._passthrough is None:
            from .resources.passthrough.client import PassthroughClient  # noqa: E402

            self._passthrough = PassthroughClient(client_wrapper=self._client_wrapper)
        return self._passthrough

    @property
    def regenerate_key(self):
        if self._regenerate_key is None:
            from .resources.regenerate_key.client import RegenerateKeyClient  # noqa: E402

            self._regenerate_key = RegenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._regenerate_key

    @property
    def reject_reasons(self):
        if self._reject_reasons is None:
            from .resources.reject_reasons.client import RejectReasonsClient  # noqa: E402

            self._reject_reasons = RejectReasonsClient(client_wrapper=self._client_wrapper)
        return self._reject_reasons

    @property
    def scorecards(self):
        if self._scorecards is None:
            from .resources.scorecards.client import ScorecardsClient  # noqa: E402

            self._scorecards = ScorecardsClient(client_wrapper=self._client_wrapper)
        return self._scorecards

    @property
    def sync_status(self):
        if self._sync_status is None:
            from .resources.sync_status.client import SyncStatusClient  # noqa: E402

            self._sync_status = SyncStatusClient(client_wrapper=self._client_wrapper)
        return self._sync_status

    @property
    def force_resync(self):
        if self._force_resync is None:
            from .resources.force_resync.client import ForceResyncClient  # noqa: E402

            self._force_resync = ForceResyncClient(client_wrapper=self._client_wrapper)
        return self._force_resync

    @property
    def tags(self):
        if self._tags is None:
            from .resources.tags.client import TagsClient  # noqa: E402

            self._tags = TagsClient(client_wrapper=self._client_wrapper)
        return self._tags

    @property
    def users(self):
        if self._users is None:
            from .resources.users.client import UsersClient  # noqa: E402

            self._users = UsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def webhook_receivers(self):
        if self._webhook_receivers is None:
            from .resources.webhook_receivers.client import WebhookReceiversClient  # noqa: E402

            self._webhook_receivers = WebhookReceiversClient(client_wrapper=self._client_wrapper)
        return self._webhook_receivers


class AsyncAtsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAtsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._account_details: typing.Optional[AsyncAccountDetailsClient] = None
        self._account_token: typing.Optional[AsyncAccountTokenClient] = None
        self._activities: typing.Optional[AsyncActivitiesClient] = None
        self._applications: typing.Optional[AsyncApplicationsClient] = None
        self._async_passthrough: typing.Optional[AsyncAsyncPassthroughClient] = None
        self._attachments: typing.Optional[AsyncAttachmentsClient] = None
        self._audit_trail: typing.Optional[AsyncAuditTrailClient] = None
        self._available_actions: typing.Optional[AsyncAvailableActionsClient] = None
        self._candidates: typing.Optional[AsyncCandidatesClient] = None
        self._scopes: typing.Optional[AsyncScopesClient] = None
        self._delete_account: typing.Optional[AsyncDeleteAccountClient] = None
        self._departments: typing.Optional[AsyncDepartmentsClient] = None
        self._eeocs: typing.Optional[AsyncEeocsClient] = None
        self._field_mapping: typing.Optional[AsyncFieldMappingClient] = None
        self._generate_key: typing.Optional[AsyncGenerateKeyClient] = None
        self._interviews: typing.Optional[AsyncInterviewsClient] = None
        self._issues: typing.Optional[AsyncIssuesClient] = None
        self._job_interview_stages: typing.Optional[AsyncJobInterviewStagesClient] = None
        self._job_postings: typing.Optional[AsyncJobPostingsClient] = None
        self._jobs: typing.Optional[AsyncJobsClient] = None
        self._link_token: typing.Optional[AsyncLinkTokenClient] = None
        self._linked_accounts: typing.Optional[AsyncLinkedAccountsClient] = None
        self._offers: typing.Optional[AsyncOffersClient] = None
        self._offices: typing.Optional[AsyncOfficesClient] = None
        self._passthrough: typing.Optional[resources_ats_resources_passthrough_client_AsyncPassthroughClient] = None
        self._regenerate_key: typing.Optional[AsyncRegenerateKeyClient] = None
        self._reject_reasons: typing.Optional[AsyncRejectReasonsClient] = None
        self._scorecards: typing.Optional[AsyncScorecardsClient] = None
        self._sync_status: typing.Optional[AsyncSyncStatusClient] = None
        self._force_resync: typing.Optional[AsyncForceResyncClient] = None
        self._tags: typing.Optional[AsyncTagsClient] = None
        self._users: typing.Optional[AsyncUsersClient] = None
        self._webhook_receivers: typing.Optional[AsyncWebhookReceiversClient] = None

    @property
    def with_raw_response(self) -> AsyncRawAtsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAtsClient
        """
        return self._raw_client

    @property
    def account_details(self):
        if self._account_details is None:
            from .resources.account_details.client import AsyncAccountDetailsClient  # noqa: E402

            self._account_details = AsyncAccountDetailsClient(client_wrapper=self._client_wrapper)
        return self._account_details

    @property
    def account_token(self):
        if self._account_token is None:
            from .resources.account_token.client import AsyncAccountTokenClient  # noqa: E402

            self._account_token = AsyncAccountTokenClient(client_wrapper=self._client_wrapper)
        return self._account_token

    @property
    def activities(self):
        if self._activities is None:
            from .resources.activities.client import AsyncActivitiesClient  # noqa: E402

            self._activities = AsyncActivitiesClient(client_wrapper=self._client_wrapper)
        return self._activities

    @property
    def applications(self):
        if self._applications is None:
            from .resources.applications.client import AsyncApplicationsClient  # noqa: E402

            self._applications = AsyncApplicationsClient(client_wrapper=self._client_wrapper)
        return self._applications

    @property
    def async_passthrough(self):
        if self._async_passthrough is None:
            from .resources.async_passthrough.client import AsyncAsyncPassthroughClient  # noqa: E402

            self._async_passthrough = AsyncAsyncPassthroughClient(client_wrapper=self._client_wrapper)
        return self._async_passthrough

    @property
    def attachments(self):
        if self._attachments is None:
            from .resources.attachments.client import AsyncAttachmentsClient  # noqa: E402

            self._attachments = AsyncAttachmentsClient(client_wrapper=self._client_wrapper)
        return self._attachments

    @property
    def audit_trail(self):
        if self._audit_trail is None:
            from .resources.audit_trail.client import AsyncAuditTrailClient  # noqa: E402

            self._audit_trail = AsyncAuditTrailClient(client_wrapper=self._client_wrapper)
        return self._audit_trail

    @property
    def available_actions(self):
        if self._available_actions is None:
            from .resources.available_actions.client import AsyncAvailableActionsClient  # noqa: E402

            self._available_actions = AsyncAvailableActionsClient(client_wrapper=self._client_wrapper)
        return self._available_actions

    @property
    def candidates(self):
        if self._candidates is None:
            from .resources.candidates.client import AsyncCandidatesClient  # noqa: E402

            self._candidates = AsyncCandidatesClient(client_wrapper=self._client_wrapper)
        return self._candidates

    @property
    def scopes(self):
        if self._scopes is None:
            from .resources.scopes.client import AsyncScopesClient  # noqa: E402

            self._scopes = AsyncScopesClient(client_wrapper=self._client_wrapper)
        return self._scopes

    @property
    def delete_account(self):
        if self._delete_account is None:
            from .resources.delete_account.client import AsyncDeleteAccountClient  # noqa: E402

            self._delete_account = AsyncDeleteAccountClient(client_wrapper=self._client_wrapper)
        return self._delete_account

    @property
    def departments(self):
        if self._departments is None:
            from .resources.departments.client import AsyncDepartmentsClient  # noqa: E402

            self._departments = AsyncDepartmentsClient(client_wrapper=self._client_wrapper)
        return self._departments

    @property
    def eeocs(self):
        if self._eeocs is None:
            from .resources.eeocs.client import AsyncEeocsClient  # noqa: E402

            self._eeocs = AsyncEeocsClient(client_wrapper=self._client_wrapper)
        return self._eeocs

    @property
    def field_mapping(self):
        if self._field_mapping is None:
            from .resources.field_mapping.client import AsyncFieldMappingClient  # noqa: E402

            self._field_mapping = AsyncFieldMappingClient(client_wrapper=self._client_wrapper)
        return self._field_mapping

    @property
    def generate_key(self):
        if self._generate_key is None:
            from .resources.generate_key.client import AsyncGenerateKeyClient  # noqa: E402

            self._generate_key = AsyncGenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._generate_key

    @property
    def interviews(self):
        if self._interviews is None:
            from .resources.interviews.client import AsyncInterviewsClient  # noqa: E402

            self._interviews = AsyncInterviewsClient(client_wrapper=self._client_wrapper)
        return self._interviews

    @property
    def issues(self):
        if self._issues is None:
            from .resources.issues.client import AsyncIssuesClient  # noqa: E402

            self._issues = AsyncIssuesClient(client_wrapper=self._client_wrapper)
        return self._issues

    @property
    def job_interview_stages(self):
        if self._job_interview_stages is None:
            from .resources.job_interview_stages.client import AsyncJobInterviewStagesClient  # noqa: E402

            self._job_interview_stages = AsyncJobInterviewStagesClient(client_wrapper=self._client_wrapper)
        return self._job_interview_stages

    @property
    def job_postings(self):
        if self._job_postings is None:
            from .resources.job_postings.client import AsyncJobPostingsClient  # noqa: E402

            self._job_postings = AsyncJobPostingsClient(client_wrapper=self._client_wrapper)
        return self._job_postings

    @property
    def jobs(self):
        if self._jobs is None:
            from .resources.jobs.client import AsyncJobsClient  # noqa: E402

            self._jobs = AsyncJobsClient(client_wrapper=self._client_wrapper)
        return self._jobs

    @property
    def link_token(self):
        if self._link_token is None:
            from .resources.link_token.client import AsyncLinkTokenClient  # noqa: E402

            self._link_token = AsyncLinkTokenClient(client_wrapper=self._client_wrapper)
        return self._link_token

    @property
    def linked_accounts(self):
        if self._linked_accounts is None:
            from .resources.linked_accounts.client import AsyncLinkedAccountsClient  # noqa: E402

            self._linked_accounts = AsyncLinkedAccountsClient(client_wrapper=self._client_wrapper)
        return self._linked_accounts

    @property
    def offers(self):
        if self._offers is None:
            from .resources.offers.client import AsyncOffersClient  # noqa: E402

            self._offers = AsyncOffersClient(client_wrapper=self._client_wrapper)
        return self._offers

    @property
    def offices(self):
        if self._offices is None:
            from .resources.offices.client import AsyncOfficesClient  # noqa: E402

            self._offices = AsyncOfficesClient(client_wrapper=self._client_wrapper)
        return self._offices

    @property
    def passthrough(self):
        if self._passthrough is None:
            from .resources.passthrough.client import (
                AsyncPassthroughClient as resources_ats_resources_passthrough_client_AsyncPassthroughClient,  # noqa: E402
            )

            self._passthrough = resources_ats_resources_passthrough_client_AsyncPassthroughClient(
                client_wrapper=self._client_wrapper
            )
        return self._passthrough

    @property
    def regenerate_key(self):
        if self._regenerate_key is None:
            from .resources.regenerate_key.client import AsyncRegenerateKeyClient  # noqa: E402

            self._regenerate_key = AsyncRegenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._regenerate_key

    @property
    def reject_reasons(self):
        if self._reject_reasons is None:
            from .resources.reject_reasons.client import AsyncRejectReasonsClient  # noqa: E402

            self._reject_reasons = AsyncRejectReasonsClient(client_wrapper=self._client_wrapper)
        return self._reject_reasons

    @property
    def scorecards(self):
        if self._scorecards is None:
            from .resources.scorecards.client import AsyncScorecardsClient  # noqa: E402

            self._scorecards = AsyncScorecardsClient(client_wrapper=self._client_wrapper)
        return self._scorecards

    @property
    def sync_status(self):
        if self._sync_status is None:
            from .resources.sync_status.client import AsyncSyncStatusClient  # noqa: E402

            self._sync_status = AsyncSyncStatusClient(client_wrapper=self._client_wrapper)
        return self._sync_status

    @property
    def force_resync(self):
        if self._force_resync is None:
            from .resources.force_resync.client import AsyncForceResyncClient  # noqa: E402

            self._force_resync = AsyncForceResyncClient(client_wrapper=self._client_wrapper)
        return self._force_resync

    @property
    def tags(self):
        if self._tags is None:
            from .resources.tags.client import AsyncTagsClient  # noqa: E402

            self._tags = AsyncTagsClient(client_wrapper=self._client_wrapper)
        return self._tags

    @property
    def users(self):
        if self._users is None:
            from .resources.users.client import AsyncUsersClient  # noqa: E402

            self._users = AsyncUsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def webhook_receivers(self):
        if self._webhook_receivers is None:
            from .resources.webhook_receivers.client import AsyncWebhookReceiversClient  # noqa: E402

            self._webhook_receivers = AsyncWebhookReceiversClient(client_wrapper=self._client_wrapper)
        return self._webhook_receivers
