# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.application import Application
from ...types.application_request import ApplicationRequest
from ...types.application_response import ApplicationResponse
from ...types.meta_response import MetaResponse
from ...types.paginated_application_list import PaginatedApplicationList
from .raw_client import AsyncRawApplicationsClient, RawApplicationsClient
from .types.applications_list_request_expand import ApplicationsListRequestExpand
from .types.applications_retrieve_request_expand import ApplicationsRetrieveRequestExpand

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ApplicationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawApplicationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawApplicationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawApplicationsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        candidate_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        credited_to_id: typing.Optional[str] = None,
        current_stage_id: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[ApplicationsListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        job_id: typing.Optional[str] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        reject_reason_id: typing.Optional[str] = None,
        remote_id: typing.Optional[str] = None,
        source: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedApplicationList:
        """
        Returns a list of `Application` objects.

        Parameters
        ----------
        candidate_id : typing.Optional[str]
            If provided, will only return applications for this candidate.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        credited_to_id : typing.Optional[str]
            If provided, will only return applications credited to this user.

        current_stage_id : typing.Optional[str]
            If provided, will only return applications at this interview stage.

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[ApplicationsListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        job_id : typing.Optional[str]
            If provided, will only return applications for this job.

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page.

        reject_reason_id : typing.Optional[str]
            If provided, will only return applications with this reject reason.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        source : typing.Optional[str]
            If provided, will only return applications with this source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedApplicationList


        Examples
        --------
        import datetime

        from merge import Merge
        from merge.resources.ats.resources.applications import (
            ApplicationsListRequestExpand,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ats.applications.list(
            candidate_id="candidate_id",
            created_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            created_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            credited_to_id="credited_to_id",
            current_stage_id="current_stage_id",
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            expand=ApplicationsListRequestExpand.CANDIDATE,
            include_deleted_data=True,
            include_remote_data=True,
            include_shell_data=True,
            job_id="job_id",
            modified_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            modified_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            page_size=1,
            reject_reason_id="reject_reason_id",
            remote_id="remote_id",
            source="source",
        )
        """
        _response = self._raw_client.list(
            candidate_id=candidate_id,
            created_after=created_after,
            created_before=created_before,
            credited_to_id=credited_to_id,
            current_stage_id=current_stage_id,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            job_id=job_id,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            reject_reason_id=reject_reason_id,
            remote_id=remote_id,
            source=source,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        model: ApplicationRequest,
        remote_user_id: str,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApplicationResponse:
        """
        Creates an `Application` object with the given values.
        For certain integrations, but not all, our API detects duplicate candidates and will associate applications with existing records in the third-party. New candidates are created and automatically linked to the application.

        See our [Help Center article](https://help.merge.dev/en/articles/10012366-updates-to-post-applications-oct-2024) for detailed support per integration.

        Parameters
        ----------
        model : ApplicationRequest

        remote_user_id : str

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplicationResponse


        Examples
        --------
        from merge import Merge
        from merge.resources.ats import ApplicationRequest

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ats.applications.create(
            is_debug_mode=True,
            run_async=True,
            model=ApplicationRequest(),
            remote_user_id="remote_user_id",
        )
        """
        _response = self._raw_client.create(
            model=model,
            remote_user_id=remote_user_id,
            is_debug_mode=is_debug_mode,
            run_async=run_async,
            request_options=request_options,
        )
        return _response.data

    def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[ApplicationsRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Application:
        """
        Returns an `Application` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[ApplicationsRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Application


        Examples
        --------
        from merge import Merge
        from merge.resources.ats.resources.applications import (
            ApplicationsRetrieveRequestExpand,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ats.applications.retrieve(
            id="id",
            expand=ApplicationsRetrieveRequestExpand.CANDIDATE,
            include_remote_data=True,
            include_shell_data=True,
        )
        """
        _response = self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data

    def change_stage_create(
        self,
        id: str,
        *,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        job_interview_stage: typing.Optional[str] = OMIT,
        remote_user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApplicationResponse:
        """
        Updates the `current_stage` field of an `Application` object

        Parameters
        ----------
        id : str

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        job_interview_stage : typing.Optional[str]
            The interview stage to move the application to.

        remote_user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplicationResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ats.applications.change_stage_create(
            id="id",
            is_debug_mode=True,
            run_async=True,
        )
        """
        _response = self._raw_client.change_stage_create(
            id,
            is_debug_mode=is_debug_mode,
            run_async=run_async,
            job_interview_stage=job_interview_stage,
            remote_user_id=remote_user_id,
            request_options=request_options,
        )
        return _response.data

    def meta_post_retrieve(
        self,
        *,
        application_remote_template_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MetaResponse:
        """
        Returns metadata for `Application` POSTs.

        Parameters
        ----------
        application_remote_template_id : typing.Optional[str]
            The template ID associated with the nested application in the request.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ats.applications.meta_post_retrieve(
            application_remote_template_id="application_remote_template_id",
        )
        """
        _response = self._raw_client.meta_post_retrieve(
            application_remote_template_id=application_remote_template_id, request_options=request_options
        )
        return _response.data


class AsyncApplicationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawApplicationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawApplicationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawApplicationsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        candidate_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        credited_to_id: typing.Optional[str] = None,
        current_stage_id: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[ApplicationsListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        job_id: typing.Optional[str] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        reject_reason_id: typing.Optional[str] = None,
        remote_id: typing.Optional[str] = None,
        source: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedApplicationList:
        """
        Returns a list of `Application` objects.

        Parameters
        ----------
        candidate_id : typing.Optional[str]
            If provided, will only return applications for this candidate.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        credited_to_id : typing.Optional[str]
            If provided, will only return applications credited to this user.

        current_stage_id : typing.Optional[str]
            If provided, will only return applications at this interview stage.

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[ApplicationsListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        job_id : typing.Optional[str]
            If provided, will only return applications for this job.

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page.

        reject_reason_id : typing.Optional[str]
            If provided, will only return applications with this reject reason.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        source : typing.Optional[str]
            If provided, will only return applications with this source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedApplicationList


        Examples
        --------
        import asyncio
        import datetime

        from merge import AsyncMerge
        from merge.resources.ats.resources.applications import (
            ApplicationsListRequestExpand,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ats.applications.list(
                candidate_id="candidate_id",
                created_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                created_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                credited_to_id="credited_to_id",
                current_stage_id="current_stage_id",
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
                expand=ApplicationsListRequestExpand.CANDIDATE,
                include_deleted_data=True,
                include_remote_data=True,
                include_shell_data=True,
                job_id="job_id",
                modified_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                modified_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                page_size=1,
                reject_reason_id="reject_reason_id",
                remote_id="remote_id",
                source="source",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            candidate_id=candidate_id,
            created_after=created_after,
            created_before=created_before,
            credited_to_id=credited_to_id,
            current_stage_id=current_stage_id,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            job_id=job_id,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            reject_reason_id=reject_reason_id,
            remote_id=remote_id,
            source=source,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        model: ApplicationRequest,
        remote_user_id: str,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApplicationResponse:
        """
        Creates an `Application` object with the given values.
        For certain integrations, but not all, our API detects duplicate candidates and will associate applications with existing records in the third-party. New candidates are created and automatically linked to the application.

        See our [Help Center article](https://help.merge.dev/en/articles/10012366-updates-to-post-applications-oct-2024) for detailed support per integration.

        Parameters
        ----------
        model : ApplicationRequest

        remote_user_id : str

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplicationResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.ats import ApplicationRequest

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ats.applications.create(
                is_debug_mode=True,
                run_async=True,
                model=ApplicationRequest(),
                remote_user_id="remote_user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            model=model,
            remote_user_id=remote_user_id,
            is_debug_mode=is_debug_mode,
            run_async=run_async,
            request_options=request_options,
        )
        return _response.data

    async def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[ApplicationsRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Application:
        """
        Returns an `Application` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[ApplicationsRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Application


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.ats.resources.applications import (
            ApplicationsRetrieveRequestExpand,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ats.applications.retrieve(
                id="id",
                expand=ApplicationsRetrieveRequestExpand.CANDIDATE,
                include_remote_data=True,
                include_shell_data=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data

    async def change_stage_create(
        self,
        id: str,
        *,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        job_interview_stage: typing.Optional[str] = OMIT,
        remote_user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApplicationResponse:
        """
        Updates the `current_stage` field of an `Application` object

        Parameters
        ----------
        id : str

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        job_interview_stage : typing.Optional[str]
            The interview stage to move the application to.

        remote_user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplicationResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ats.applications.change_stage_create(
                id="id",
                is_debug_mode=True,
                run_async=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.change_stage_create(
            id,
            is_debug_mode=is_debug_mode,
            run_async=run_async,
            job_interview_stage=job_interview_stage,
            remote_user_id=remote_user_id,
            request_options=request_options,
        )
        return _response.data

    async def meta_post_retrieve(
        self,
        *,
        application_remote_template_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MetaResponse:
        """
        Returns metadata for `Application` POSTs.

        Parameters
        ----------
        application_remote_template_id : typing.Optional[str]
            The template ID associated with the nested application in the request.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ats.applications.meta_post_retrieve(
                application_remote_template_id="application_remote_template_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.meta_post_retrieve(
            application_remote_template_id=application_remote_template_id, request_options=request_options
        )
        return _response.data
