# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .activity_request_activity_type import ActivityRequestActivityType
from .activity_request_user import ActivityRequestUser
from .activity_request_visibility import ActivityRequestVisibility


class ActivityRequest(UncheckedBaseModel):
    """
    # The Activity Object
    ### Description
    The `Activity` object is used to represent an activity for a candidate performed by a user.
    ### Usage Example
    Fetch from the `LIST Activities` endpoint and filter by `ID` to show all activities.
    """

    user: typing.Optional[ActivityRequestUser] = pydantic.Field(default=None)
    """
    The user that performed the action.
    """

    activity_type: typing.Optional[ActivityRequestActivityType] = pydantic.Field(default=None)
    """
    The activity's type.
    
    * `NOTE` - NOTE
    * `EMAIL` - EMAIL
    * `OTHER` - OTHER
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    The activity's subject.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The activity's body.
    """

    visibility: typing.Optional[ActivityRequestVisibility] = pydantic.Field(default=None)
    """
    The activity's visibility.
    
    * `ADMIN_ONLY` - ADMIN_ONLY
    * `PUBLIC` - PUBLIC
    * `PRIVATE` - PRIVATE
    """

    candidate: typing.Optional[str] = None
    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
