# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .attachment_request_attachment_type import AttachmentRequestAttachmentType


class AttachmentRequest(UncheckedBaseModel):
    """
    # The Attachment Object
    ### Description
    The `Attachment` object is used to represent a file attached to a candidate.
    ### Usage Example
    Fetch from the `LIST Attachments` endpoint and view attachments accessible by a company.
    """

    file_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The attachment's name.
    """

    file_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The attachment's url.
    """

    candidate: typing.Optional[str] = pydantic.Field(default=None)
    """
    
    """

    attachment_type: typing.Optional[AttachmentRequestAttachmentType] = pydantic.Field(default=None)
    """
    The attachment's type.
    
    * `RESUME` - RESUME
    * `COVER_LETTER` - COVER_LETTER
    * `OFFER_LETTER` - OFFER_LETTER
    * `OTHER` - OTHER
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
