# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .job_interview_stage_job import JobInterviewStageJob
from .remote_data import RemoteData


class JobInterviewStage(UncheckedBaseModel):
    """
    # The JobInterviewStage Object
    ### Description
    The `JobInterviewStage` object is used to represent a particular recruiting stage for an `Application`. A given `Application` typically has the `JobInterviewStage` object represented in the current_stage field.
    ### Usage Example
    Fetch from the `LIST JobInterviewStages` endpoint and view the job interview stages used by a company.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Standard stage names are offered by ATS systems but can be modified by users.
    """

    job: typing.Optional[JobInterviewStageJob] = pydantic.Field(default=None)
    """
    This field is populated only if the stage is specific to a particular job. If the stage is generic, this field will not be populated.
    """

    stage_order: typing.Optional[int] = pydantic.Field(default=None)
    """
    The stage’s order, with the lowest values ordered first. If the third-party does not return details on the order of stages, this field will not be populated.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
