# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .multipart_form_field_request_encoding import MultipartFormFieldRequestEncoding


class MultipartFormFieldRequest(UncheckedBaseModel):
    """
    # The MultipartFormField Object
    ### Description
    The `MultipartFormField` object is used to represent fields in an HTTP request using `multipart/form-data`.

    ### Usage Example
    Create a `MultipartFormField` to define a multipart form entry.
    """

    name: str = pydantic.Field()
    """
    The name of the form field
    """

    data: str = pydantic.Field()
    """
    The data for the form field.
    """

    encoding: typing.Optional[MultipartFormFieldRequestEncoding] = pydantic.Field(default=None)
    """
    The encoding of the value of `data`. Defaults to `RAW` if not defined.
    
    * `RAW` - RAW
    * `BASE64` - BASE64
    * `GZIP_BASE64` - GZIP_BASE64
    """

    file_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The file name of the form field, if the field is for a file.
    """

    content_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The MIME type of the file, if the field is for a file.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
