# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .email_address_request import EmailAddressRequest
from .phone_number_request import PhoneNumberRequest
from .url_request import UrlRequest


class PatchedCandidateRequest(UncheckedBaseModel):
    """
    # The Candidate Object
    ### Description
    The `Candidate` object is used to represent profile information about a given Candidate. Because it is specific to a Candidate, this information stays constant across applications.
    ### Usage Example
    Fetch from the `LIST Candidates` endpoint and filter by `ID` to show all candidates.
    """

    first_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The candidate's first name.
    """

    last_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The candidate's last name.
    """

    company: typing.Optional[str] = pydantic.Field(default=None)
    """
    The candidate's current company.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The candidate's current title.
    """

    last_interaction_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the most recent interaction with the candidate occurred.
    """

    is_private: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the candidate is private.
    """

    can_email: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the candidate can be emailed.
    """

    locations: typing.Optional[typing.List[typing.Optional[str]]] = pydantic.Field(default=None)
    """
    The candidate's locations.
    """

    phone_numbers: typing.Optional[typing.List[PhoneNumberRequest]] = None
    email_addresses: typing.Optional[typing.List[EmailAddressRequest]] = None
    urls: typing.Optional[typing.List[UrlRequest]] = None
    tags: typing.Optional[typing.List[typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Array of `Tag` names as strings.
    """

    applications: typing.Optional[typing.List[typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Array of `Application` object IDs.
    """

    attachments: typing.Optional[typing.List[typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Array of `Attachment` object IDs.
    """

    remote_template_id: typing.Optional[str] = None
    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
