# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .remote_data import RemoteData
from .scorecard_application import ScorecardApplication
from .scorecard_interview import ScorecardInterview
from .scorecard_interviewer import ScorecardInterviewer
from .scorecard_overall_recommendation import ScorecardOverallRecommendation


class Scorecard(UncheckedBaseModel):
    """
    # The Scorecard Object
    ### Description
    The `Scorecard` object is used to represent an interviewer's candidate recommendation based on a particular interview.
    ### Usage Example
    Fetch from the `LIST Scorecards` endpoint and filter by `application` to show all scorecard for an applicant.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    application: typing.Optional[ScorecardApplication] = pydantic.Field(default=None)
    """
    The application being scored.
    """

    interview: typing.Optional[ScorecardInterview] = pydantic.Field(default=None)
    """
    The interview being scored.
    """

    interviewer: typing.Optional[ScorecardInterviewer] = pydantic.Field(default=None)
    """
    The interviewer doing the scoring.
    """

    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's scorecard was created.
    """

    submitted_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the scorecard was submitted.
    """

    overall_recommendation: typing.Optional[ScorecardOverallRecommendation] = pydantic.Field(default=None)
    """
    The inteviewer's recommendation.
    
    * `DEFINITELY_NO` - DEFINITELY_NO
    * `NO` - NO
    * `YES` - YES
    * `STRONG_YES` - STRONG_YES
    * `NO_DECISION` - NO_DECISION
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .application import Application  # noqa: E402, F401, I001
from .candidate import Candidate  # noqa: E402, F401, I001
from .offer import Offer  # noqa: E402, F401, I001

update_forward_refs(Scorecard)
