# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .url_request_url_type import UrlRequestUrlType


class UrlRequest(UncheckedBaseModel):
    """
    # The Url Object
    ### Description
    The `Url` object is used to represent hyperlinks associated with the parent model.
    ### Usage Example
    Fetch from the `GET Candidate` endpoint and view their website urls.
    """

    value: typing.Optional[str] = pydantic.Field(default=None)
    """
    The site's url.
    """

    url_type: typing.Optional[UrlRequestUrlType] = pydantic.Field(default=None)
    """
    The type of site.
    
    * `PERSONAL` - PERSONAL
    * `COMPANY` - COMPANY
    * `PORTFOLIO` - PORTFOLIO
    * `BLOG` - BLOG
    * `SOCIAL_MEDIA` - SOCIAL_MEDIA
    * `OTHER` - OTHER
    * `JOB_POSTING` - JOB_POSTING
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
