# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .conversation_type import ConversationType
from .remote_data import RemoteData


class Conversation(UncheckedBaseModel):
    """
    # The Conversation Object
    ### Description
    The `Conversation` object is used to represent a conversation within the Chat account.

    ### Usage Example
    Fetch from the `GET /api/chat/v1/conversations` endpoint and view their conversations.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the conversation
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the conversation.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The url of the conversation.
    """

    type: typing.Optional[ConversationType] = pydantic.Field(default=None)
    """
    The type of the conversation.
    
    * `PRIVATE_INTERNAL` - PRIVATE_INTERNAL
    * `PRIVATE_EXTERNAL` - PRIVATE_EXTERNAL
    * `PUBLIC_INTERNAL` - PUBLIC_INTERNAL
    * `PUBLIC_EXTERNAL` - PUBLIC_EXTERNAL
    """

    members: typing.Optional[typing.List[typing.Optional[str]]] = None
    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's conversation was created.
    """

    remote_updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's conversation was updated.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
