# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel


class Message(UncheckedBaseModel):
    """
    # The Message Object
    ### Description
    The `Message` object is used to represent a message within the Chat account.
    ### Usage Example
    Fetch from the `GET /api/chat/v1/messages` endpoint and view their message.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The user that sent the message.
    """

    conversation_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The conversation this message belongs to.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The body of the message.
    """

    subject_line: typing.Optional[str] = pydantic.Field(default=None)
    """
    The subject line of the message.
    """

    root_message_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The root message this message belongs to.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The url of the message.
    """

    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's conversation was created.
    """

    remote_updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's conversation was updated.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
