# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .remote_data import RemoteData


class User(UncheckedBaseModel):
    """
    # The User Object
    ### Description
    The `User` object is used to represent a user within the Chat account.

    ### Usage Example
    Fetch from the `GET /api/chat/v1/users` endpoint and view their users.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    username: typing.Optional[str] = pydantic.Field(default=None)
    """
    Username or handle
    """

    display_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Full name or display name
    """

    first_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The user's first name
    """

    last_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The user's last name
    """

    is_bot: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Returns true if the user is a bot
    """

    groups: typing.Optional[typing.List[typing.Optional[str]]] = None
    avatar: typing.Optional[str] = pydantic.Field(default=None)
    """
    The user's avatar image
    """

    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's user was created.
    """

    remote_updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's user was updated.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
