# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.association_type import AssociationType
from ...types.association_type_request_request import AssociationTypeRequestRequest
from ...types.crm_association_type_response import CrmAssociationTypeResponse
from ...types.meta_response import MetaResponse
from ...types.paginated_association_type_list import PaginatedAssociationTypeList
from .raw_client import AsyncRawAssociationTypesClient, RawAssociationTypesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AssociationTypesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAssociationTypesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAssociationTypesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAssociationTypesClient
        """
        return self._raw_client

    def custom_object_classes_association_types_list(
        self,
        custom_object_class_id: str,
        *,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[typing.Literal["target_object_classes"]] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        remote_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedAssociationTypeList:
        """
        Returns a list of `AssociationType` objects.

        Parameters
        ----------
        custom_object_class_id : str

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[typing.Literal["target_object_classes"]]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedAssociationTypeList


        Examples
        --------
        import datetime

        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.association_types.custom_object_classes_association_types_list(
            custom_object_class_id="custom_object_class_id",
            created_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            created_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            include_deleted_data=True,
            include_remote_data=True,
            include_shell_data=True,
            modified_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            modified_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            page_size=1,
            remote_id="remote_id",
        )
        """
        _response = self._raw_client.custom_object_classes_association_types_list(
            custom_object_class_id,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            remote_id=remote_id,
            request_options=request_options,
        )
        return _response.data

    def custom_object_classes_association_types_create(
        self,
        custom_object_class_id: str,
        *,
        model: AssociationTypeRequestRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CrmAssociationTypeResponse:
        """
        Creates an `AssociationType` object with the given values.

        Parameters
        ----------
        custom_object_class_id : str

        model : AssociationTypeRequestRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CrmAssociationTypeResponse


        Examples
        --------
        from merge import Merge
        from merge.resources.crm import (
            AssociationTypeRequestRequest,
            ObjectClassDescriptionRequest,
            OriginTypeEnum,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.association_types.custom_object_classes_association_types_create(
            custom_object_class_id="custom_object_class_id",
            is_debug_mode=True,
            run_async=True,
            model=AssociationTypeRequestRequest(
                source_object_class=ObjectClassDescriptionRequest(
                    id="id",
                    origin_type=OriginTypeEnum.CUSTOM_OBJECT,
                ),
                target_object_classes=[
                    ObjectClassDescriptionRequest(
                        id="id",
                        origin_type=OriginTypeEnum.CUSTOM_OBJECT,
                    )
                ],
                remote_key_name="remote_key_name",
            ),
        )
        """
        _response = self._raw_client.custom_object_classes_association_types_create(
            custom_object_class_id,
            model=model,
            is_debug_mode=is_debug_mode,
            run_async=run_async,
            request_options=request_options,
        )
        return _response.data

    def custom_object_classes_association_types_retrieve(
        self,
        custom_object_class_id: str,
        id: str,
        *,
        expand: typing.Optional[typing.Literal["target_object_classes"]] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AssociationType:
        """
        Returns an `AssociationType` object with the given `id`.

        Parameters
        ----------
        custom_object_class_id : str

        id : str

        expand : typing.Optional[typing.Literal["target_object_classes"]]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AssociationType


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.association_types.custom_object_classes_association_types_retrieve(
            custom_object_class_id="custom_object_class_id",
            id="id",
            include_remote_data=True,
            include_shell_data=True,
        )
        """
        _response = self._raw_client.custom_object_classes_association_types_retrieve(
            custom_object_class_id,
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data

    def custom_object_classes_association_types_meta_post_retrieve(
        self, custom_object_class_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MetaResponse:
        """
        Returns metadata for `CRMAssociationType` POSTs.

        Parameters
        ----------
        custom_object_class_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.association_types.custom_object_classes_association_types_meta_post_retrieve(
            custom_object_class_id="custom_object_class_id",
        )
        """
        _response = self._raw_client.custom_object_classes_association_types_meta_post_retrieve(
            custom_object_class_id, request_options=request_options
        )
        return _response.data


class AsyncAssociationTypesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAssociationTypesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAssociationTypesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAssociationTypesClient
        """
        return self._raw_client

    async def custom_object_classes_association_types_list(
        self,
        custom_object_class_id: str,
        *,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[typing.Literal["target_object_classes"]] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        remote_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedAssociationTypeList:
        """
        Returns a list of `AssociationType` objects.

        Parameters
        ----------
        custom_object_class_id : str

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[typing.Literal["target_object_classes"]]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedAssociationTypeList


        Examples
        --------
        import asyncio
        import datetime

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.association_types.custom_object_classes_association_types_list(
                custom_object_class_id="custom_object_class_id",
                created_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                created_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
                include_deleted_data=True,
                include_remote_data=True,
                include_shell_data=True,
                modified_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                modified_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                page_size=1,
                remote_id="remote_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.custom_object_classes_association_types_list(
            custom_object_class_id,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            remote_id=remote_id,
            request_options=request_options,
        )
        return _response.data

    async def custom_object_classes_association_types_create(
        self,
        custom_object_class_id: str,
        *,
        model: AssociationTypeRequestRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CrmAssociationTypeResponse:
        """
        Creates an `AssociationType` object with the given values.

        Parameters
        ----------
        custom_object_class_id : str

        model : AssociationTypeRequestRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CrmAssociationTypeResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.crm import (
            AssociationTypeRequestRequest,
            ObjectClassDescriptionRequest,
            OriginTypeEnum,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.association_types.custom_object_classes_association_types_create(
                custom_object_class_id="custom_object_class_id",
                is_debug_mode=True,
                run_async=True,
                model=AssociationTypeRequestRequest(
                    source_object_class=ObjectClassDescriptionRequest(
                        id="id",
                        origin_type=OriginTypeEnum.CUSTOM_OBJECT,
                    ),
                    target_object_classes=[
                        ObjectClassDescriptionRequest(
                            id="id",
                            origin_type=OriginTypeEnum.CUSTOM_OBJECT,
                        )
                    ],
                    remote_key_name="remote_key_name",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.custom_object_classes_association_types_create(
            custom_object_class_id,
            model=model,
            is_debug_mode=is_debug_mode,
            run_async=run_async,
            request_options=request_options,
        )
        return _response.data

    async def custom_object_classes_association_types_retrieve(
        self,
        custom_object_class_id: str,
        id: str,
        *,
        expand: typing.Optional[typing.Literal["target_object_classes"]] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AssociationType:
        """
        Returns an `AssociationType` object with the given `id`.

        Parameters
        ----------
        custom_object_class_id : str

        id : str

        expand : typing.Optional[typing.Literal["target_object_classes"]]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AssociationType


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.association_types.custom_object_classes_association_types_retrieve(
                custom_object_class_id="custom_object_class_id",
                id="id",
                include_remote_data=True,
                include_shell_data=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.custom_object_classes_association_types_retrieve(
            custom_object_class_id,
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data

    async def custom_object_classes_association_types_meta_post_retrieve(
        self, custom_object_class_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MetaResponse:
        """
        Returns metadata for `CRMAssociationType` POSTs.

        Parameters
        ----------
        custom_object_class_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.association_types.custom_object_classes_association_types_meta_post_retrieve(
                custom_object_class_id="custom_object_class_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.custom_object_classes_association_types_meta_post_retrieve(
            custom_object_class_id, request_options=request_options
        )
        return _response.data
