# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.contact import Contact
from ...types.contact_request import ContactRequest
from ...types.crm_contact_response import CrmContactResponse
from ...types.ignore_common_model_request import IgnoreCommonModelRequest
from ...types.meta_response import MetaResponse
from ...types.paginated_contact_list import PaginatedContactList
from ...types.paginated_remote_field_class_list import PaginatedRemoteFieldClassList
from ...types.patched_contact_request import PatchedContactRequest
from .raw_client import AsyncRawContactsClient, RawContactsClient
from .types.contacts_list_request_expand import ContactsListRequestExpand
from .types.contacts_retrieve_request_expand import ContactsRetrieveRequestExpand

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ContactsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawContactsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawContactsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawContactsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        account_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        email_addresses: typing.Optional[str] = None,
        expand: typing.Optional[ContactsListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        phone_numbers: typing.Optional[str] = None,
        remote_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedContactList:
        """
        Returns a list of `Contact` objects.

        Parameters
        ----------
        account_id : typing.Optional[str]
            If provided, will only return contacts with this account.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        email_addresses : typing.Optional[str]
            If provided, will only return contacts matching the email addresses; multiple email_addresses can be separated by commas.

        expand : typing.Optional[ContactsListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page.

        phone_numbers : typing.Optional[str]
            If provided, will only return contacts matching the phone numbers; multiple phone numbers can be separated by commas.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedContactList


        Examples
        --------
        import datetime

        from merge import Merge
        from merge.resources.crm.resources.contacts import ContactsListRequestExpand

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.contacts.list(
            account_id="account_id",
            created_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            created_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            email_addresses="email_addresses",
            expand=ContactsListRequestExpand.ACCOUNT,
            include_deleted_data=True,
            include_remote_data=True,
            include_remote_fields=True,
            include_shell_data=True,
            modified_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            modified_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            page_size=1,
            phone_numbers="phone_numbers",
            remote_id="remote_id",
        )
        """
        _response = self._raw_client.list(
            account_id=account_id,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            email_addresses=email_addresses,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            phone_numbers=phone_numbers,
            remote_id=remote_id,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        model: ContactRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CrmContactResponse:
        """
        Creates a `Contact` object with the given values.

        Parameters
        ----------
        model : ContactRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CrmContactResponse


        Examples
        --------
        from merge import Merge
        from merge.resources.crm import ContactRequest

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.contacts.create(
            is_debug_mode=True,
            run_async=True,
            model=ContactRequest(),
        )
        """
        _response = self._raw_client.create(
            model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[ContactsRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Contact:
        """
        Returns a `Contact` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[ContactsRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Contact


        Examples
        --------
        from merge import Merge
        from merge.resources.crm.resources.contacts import ContactsRetrieveRequestExpand

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.contacts.retrieve(
            id="id",
            expand=ContactsRetrieveRequestExpand.ACCOUNT,
            include_remote_data=True,
            include_remote_fields=True,
            include_shell_data=True,
        )
        """
        _response = self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data

    def partial_update(
        self,
        id: str,
        *,
        model: PatchedContactRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CrmContactResponse:
        """
        Updates a `Contact` object with the given `id`.

        Parameters
        ----------
        id : str

        model : PatchedContactRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CrmContactResponse


        Examples
        --------
        from merge import Merge
        from merge.resources.crm import PatchedContactRequest

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.contacts.partial_update(
            id="id",
            is_debug_mode=True,
            run_async=True,
            model=PatchedContactRequest(),
        )
        """
        _response = self._raw_client.partial_update(
            id, model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    def ignore_create(
        self,
        model_id: str,
        *,
        request: IgnoreCommonModelRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Ignores a specific row based on the `model_id` in the url. These records will have their properties set to null, and will not be updated in future syncs. The "reason" and "message" fields in the request body will be stored for audit purposes.

        Parameters
        ----------
        model_id : str

        request : IgnoreCommonModelRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from merge import Merge
        from merge.resources.crm import IgnoreCommonModelRequest, ReasonEnum

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.contacts.ignore_create(
            model_id="model_id",
            request=IgnoreCommonModelRequest(
                reason=ReasonEnum.GENERAL_CUSTOMER_REQUEST,
            ),
        )
        """
        _response = self._raw_client.ignore_create(model_id, request=request, request_options=request_options)
        return _response.data

    def meta_patch_retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> MetaResponse:
        """
        Returns metadata for `CRMContact` PATCHs.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.contacts.meta_patch_retrieve(
            id="id",
        )
        """
        _response = self._raw_client.meta_patch_retrieve(id, request_options=request_options)
        return _response.data

    def meta_post_retrieve(self, *, request_options: typing.Optional[RequestOptions] = None) -> MetaResponse:
        """
        Returns metadata for `CRMContact` POSTs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.contacts.meta_post_retrieve()
        """
        _response = self._raw_client.meta_post_retrieve(request_options=request_options)
        return _response.data

    def remote_field_classes_list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        is_common_model_field: typing.Optional[bool] = None,
        is_custom: typing.Optional[bool] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedRemoteFieldClassList:
        """
        Returns a list of `RemoteFieldClass` objects.

        Parameters
        ----------
        cursor : typing.Optional[str]
            The pagination cursor value.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        is_common_model_field : typing.Optional[bool]
            If provided, will only return remote field classes with this is_common_model_field value

        is_custom : typing.Optional[bool]
            If provided, will only return remote fields classes with this is_custom value

        page_size : typing.Optional[int]
            Number of results to return per page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedRemoteFieldClassList


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.contacts.remote_field_classes_list(
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            include_deleted_data=True,
            include_remote_data=True,
            include_remote_fields=True,
            include_shell_data=True,
            is_common_model_field=True,
            is_custom=True,
            page_size=1,
        )
        """
        _response = self._raw_client.remote_field_classes_list(
            cursor=cursor,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            is_common_model_field=is_common_model_field,
            is_custom=is_custom,
            page_size=page_size,
            request_options=request_options,
        )
        return _response.data


class AsyncContactsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawContactsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawContactsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawContactsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        account_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        email_addresses: typing.Optional[str] = None,
        expand: typing.Optional[ContactsListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        phone_numbers: typing.Optional[str] = None,
        remote_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedContactList:
        """
        Returns a list of `Contact` objects.

        Parameters
        ----------
        account_id : typing.Optional[str]
            If provided, will only return contacts with this account.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        email_addresses : typing.Optional[str]
            If provided, will only return contacts matching the email addresses; multiple email_addresses can be separated by commas.

        expand : typing.Optional[ContactsListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page.

        phone_numbers : typing.Optional[str]
            If provided, will only return contacts matching the phone numbers; multiple phone numbers can be separated by commas.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedContactList


        Examples
        --------
        import asyncio
        import datetime

        from merge import AsyncMerge
        from merge.resources.crm.resources.contacts import ContactsListRequestExpand

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.contacts.list(
                account_id="account_id",
                created_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                created_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
                email_addresses="email_addresses",
                expand=ContactsListRequestExpand.ACCOUNT,
                include_deleted_data=True,
                include_remote_data=True,
                include_remote_fields=True,
                include_shell_data=True,
                modified_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                modified_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                page_size=1,
                phone_numbers="phone_numbers",
                remote_id="remote_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            account_id=account_id,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            email_addresses=email_addresses,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            phone_numbers=phone_numbers,
            remote_id=remote_id,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        model: ContactRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CrmContactResponse:
        """
        Creates a `Contact` object with the given values.

        Parameters
        ----------
        model : ContactRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CrmContactResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.crm import ContactRequest

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.contacts.create(
                is_debug_mode=True,
                run_async=True,
                model=ContactRequest(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    async def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[ContactsRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Contact:
        """
        Returns a `Contact` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[ContactsRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Contact


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.crm.resources.contacts import ContactsRetrieveRequestExpand

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.contacts.retrieve(
                id="id",
                expand=ContactsRetrieveRequestExpand.ACCOUNT,
                include_remote_data=True,
                include_remote_fields=True,
                include_shell_data=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data

    async def partial_update(
        self,
        id: str,
        *,
        model: PatchedContactRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CrmContactResponse:
        """
        Updates a `Contact` object with the given `id`.

        Parameters
        ----------
        id : str

        model : PatchedContactRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CrmContactResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.crm import PatchedContactRequest

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.contacts.partial_update(
                id="id",
                is_debug_mode=True,
                run_async=True,
                model=PatchedContactRequest(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.partial_update(
            id, model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    async def ignore_create(
        self,
        model_id: str,
        *,
        request: IgnoreCommonModelRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Ignores a specific row based on the `model_id` in the url. These records will have their properties set to null, and will not be updated in future syncs. The "reason" and "message" fields in the request body will be stored for audit purposes.

        Parameters
        ----------
        model_id : str

        request : IgnoreCommonModelRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.crm import IgnoreCommonModelRequest, ReasonEnum

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.contacts.ignore_create(
                model_id="model_id",
                request=IgnoreCommonModelRequest(
                    reason=ReasonEnum.GENERAL_CUSTOMER_REQUEST,
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.ignore_create(model_id, request=request, request_options=request_options)
        return _response.data

    async def meta_patch_retrieve(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MetaResponse:
        """
        Returns metadata for `CRMContact` PATCHs.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.contacts.meta_patch_retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.meta_patch_retrieve(id, request_options=request_options)
        return _response.data

    async def meta_post_retrieve(self, *, request_options: typing.Optional[RequestOptions] = None) -> MetaResponse:
        """
        Returns metadata for `CRMContact` POSTs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.contacts.meta_post_retrieve()


        asyncio.run(main())
        """
        _response = await self._raw_client.meta_post_retrieve(request_options=request_options)
        return _response.data

    async def remote_field_classes_list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        is_common_model_field: typing.Optional[bool] = None,
        is_custom: typing.Optional[bool] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedRemoteFieldClassList:
        """
        Returns a list of `RemoteFieldClass` objects.

        Parameters
        ----------
        cursor : typing.Optional[str]
            The pagination cursor value.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        is_common_model_field : typing.Optional[bool]
            If provided, will only return remote field classes with this is_common_model_field value

        is_custom : typing.Optional[bool]
            If provided, will only return remote fields classes with this is_custom value

        page_size : typing.Optional[int]
            Number of results to return per page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedRemoteFieldClassList


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.contacts.remote_field_classes_list(
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
                include_deleted_data=True,
                include_remote_data=True,
                include_remote_fields=True,
                include_shell_data=True,
                is_common_model_field=True,
                is_custom=True,
                page_size=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.remote_field_classes_list(
            cursor=cursor,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            is_common_model_field=is_common_model_field,
            is_custom=is_custom,
            page_size=page_size,
            request_options=request_options,
        )
        return _response.data
