# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class TasksListRequestExpand(str, enum.Enum):
    ACCOUNT = "account"
    ACCOUNT_OPPORTUNITY = "account,opportunity"
    OPPORTUNITY = "opportunity"
    OWNER = "owner"
    OWNER_ACCOUNT = "owner,account"
    OWNER_ACCOUNT_OPPORTUNITY = "owner,account,opportunity"
    OWNER_OPPORTUNITY = "owner,opportunity"

    def visit(
        self,
        account: typing.Callable[[], T_Result],
        account_opportunity: typing.Callable[[], T_Result],
        opportunity: typing.Callable[[], T_Result],
        owner: typing.Callable[[], T_Result],
        owner_account: typing.Callable[[], T_Result],
        owner_account_opportunity: typing.Callable[[], T_Result],
        owner_opportunity: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is TasksListRequestExpand.ACCOUNT:
            return account()
        if self is TasksListRequestExpand.ACCOUNT_OPPORTUNITY:
            return account_opportunity()
        if self is TasksListRequestExpand.OPPORTUNITY:
            return opportunity()
        if self is TasksListRequestExpand.OWNER:
            return owner()
        if self is TasksListRequestExpand.OWNER_ACCOUNT:
            return owner_account()
        if self is TasksListRequestExpand.OWNER_ACCOUNT_OPPORTUNITY:
            return owner_account_opportunity()
        if self is TasksListRequestExpand.OWNER_OPPORTUNITY:
            return owner_opportunity()
