# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .remote_field_class_for_custom_object_class import RemoteFieldClassForCustomObjectClass


class CustomObjectClass(UncheckedBaseModel):
    """
    # The Custom Object Class Object
    ### Description
    The `Custom Object Class` object is used to represent a Custom Object Schema in the remote system.
    ### Usage Example
    TODO
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = None
    modified_at: typing.Optional[dt.datetime] = None
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The custom object class's name.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The custom object class's description.
    """

    labels: typing.Optional[typing.Dict[str, typing.Optional[str]]] = pydantic.Field(default=None)
    """
    The custom object class's singular and plural labels.
    """

    fields: typing.Optional[typing.List[RemoteFieldClassForCustomObjectClass]] = None
    association_types: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(
        default=None
    )
    """
    The types of associations with other models that the custom object class can have.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
