# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .engagement_account import EngagementAccount
from .engagement_contacts_item import EngagementContactsItem
from .engagement_direction import EngagementDirection
from .engagement_engagement_type import EngagementEngagementType
from .engagement_owner import EngagementOwner
from .remote_data import RemoteData
from .remote_field import RemoteField


class Engagement(UncheckedBaseModel):
    """
    # The Engagement Object
    ### Description
    The `Engagement` object is used to represent an interaction noted in a CRM system.
    ### Usage Example
    TODO
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    owner: typing.Optional[EngagementOwner] = pydantic.Field(default=None)
    """
    The engagement's owner.
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    The engagement's content.
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    The engagement's subject.
    """

    direction: typing.Optional[EngagementDirection] = pydantic.Field(default=None)
    """
    The engagement's direction.
    
    * `INBOUND` - INBOUND
    * `OUTBOUND` - OUTBOUND
    """

    engagement_type: typing.Optional[EngagementEngagementType] = pydantic.Field(default=None)
    """
    The engagement type of the engagement.
    """

    start_time: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time at which the engagement started.
    """

    end_time: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time at which the engagement ended.
    """

    account: typing.Optional[EngagementAccount] = pydantic.Field(default=None)
    """
    The account of the engagement.
    """

    contacts: typing.Optional[typing.List[typing.Optional[EngagementContactsItem]]] = None
    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None
    remote_fields: typing.Optional[typing.List[RemoteField]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
