# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .address_request import AddressRequest
from .email_address_request import EmailAddressRequest
from .lead_request_converted_account import LeadRequestConvertedAccount
from .lead_request_converted_contact import LeadRequestConvertedContact
from .lead_request_owner import LeadRequestOwner
from .phone_number_request import PhoneNumberRequest
from .remote_field_request import RemoteFieldRequest


class LeadRequest(UncheckedBaseModel):
    """
    # The Lead Object
    ### Description
    The `Lead` object is used to represent an individual who is a potential customer.
    ### Usage Example
    TODO
    """

    owner: typing.Optional[LeadRequestOwner] = pydantic.Field(default=None)
    """
    The lead's owner.
    """

    lead_source: typing.Optional[str] = pydantic.Field(default=None)
    """
    The lead's source.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The lead's title.
    """

    company: typing.Optional[str] = pydantic.Field(default=None)
    """
    The lead's company.
    """

    first_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The lead's first name.
    """

    last_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The lead's last name.
    """

    addresses: typing.Optional[typing.List[AddressRequest]] = None
    email_addresses: typing.Optional[typing.List[EmailAddressRequest]] = None
    phone_numbers: typing.Optional[typing.List[PhoneNumberRequest]] = None
    converted_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the lead was converted.
    """

    converted_contact: typing.Optional[LeadRequestConvertedContact] = pydantic.Field(default=None)
    """
    The contact of the converted lead.
    """

    converted_account: typing.Optional[LeadRequestConvertedAccount] = pydantic.Field(default=None)
    """
    The account of the converted lead.
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_fields: typing.Optional[typing.List[RemoteFieldRequest]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
