# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .note_account import NoteAccount
from .note_contact import NoteContact
from .note_opportunity import NoteOpportunity
from .note_owner import NoteOwner
from .remote_data import RemoteData
from .remote_field import RemoteField


class Note(UncheckedBaseModel):
    """
    # The Note Object
    ### Description
    The `Note` object is used to represent a note on another object.
    ### Usage Example
    TODO
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    owner: typing.Optional[NoteOwner] = pydantic.Field(default=None)
    """
    The note's owner.
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    The note's content.
    """

    contact: typing.Optional[NoteContact] = pydantic.Field(default=None)
    """
    The note's contact.
    """

    account: typing.Optional[NoteAccount] = pydantic.Field(default=None)
    """
    The note's account.
    """

    opportunity: typing.Optional[NoteOpportunity] = pydantic.Field(default=None)
    """
    The note's opportunity.
    """

    remote_updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's lead was updated.
    """

    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's lead was created.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None
    remote_fields: typing.Optional[typing.List[RemoteField]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
