# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .remote_field_request import RemoteFieldRequest
from .task_request_account import TaskRequestAccount
from .task_request_opportunity import TaskRequestOpportunity
from .task_request_owner import TaskRequestOwner
from .task_request_status import TaskRequestStatus


class TaskRequest(UncheckedBaseModel):
    """
    # The Task Object
    ### Description
    The `Task` object is used to represent a task, such as a to-do item.
    ### Usage Example
    TODO
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    The task's subject.
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    The task's content.
    """

    owner: typing.Optional[TaskRequestOwner] = pydantic.Field(default=None)
    """
    The task's owner.
    """

    account: typing.Optional[TaskRequestAccount] = pydantic.Field(default=None)
    """
    The task's account.
    """

    opportunity: typing.Optional[TaskRequestOpportunity] = pydantic.Field(default=None)
    """
    The task's opportunity.
    """

    completed_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the task is completed.
    """

    due_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the task is due.
    """

    status: typing.Optional[TaskRequestStatus] = pydantic.Field(default=None)
    """
    The task's status.
    
    * `OPEN` - OPEN
    * `CLOSED` - CLOSED
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_fields: typing.Optional[typing.List[RemoteFieldRequest]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
