# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.file_storage_folder_response import FileStorageFolderResponse
from ...types.folder import Folder
from ...types.folder_request import FolderRequest
from ...types.meta_response import MetaResponse
from ...types.paginated_folder_list import PaginatedFolderList
from .raw_client import AsyncRawFoldersClient, RawFoldersClient
from .types.folders_list_request_expand import FoldersListRequestExpand
from .types.folders_retrieve_request_expand import FoldersRetrieveRequestExpand

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FoldersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFoldersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFoldersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFoldersClient
        """
        return self._raw_client

    def list(
        self,
        *,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        drive_id: typing.Optional[str] = None,
        expand: typing.Optional[FoldersListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        name: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        parent_folder_id: typing.Optional[str] = None,
        remote_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedFolderList:
        """
        Returns a list of `Folder` objects.

        Parameters
        ----------
        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        drive_id : typing.Optional[str]
            If provided, will only return folders in this drive.

        expand : typing.Optional[FoldersListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        name : typing.Optional[str]
            If provided, will only return folders with this name. This performs an exact match.

        page_size : typing.Optional[int]
            Number of results to return per page.

        parent_folder_id : typing.Optional[str]
            If provided, will only return folders in this parent folder. If null, will return folders in root directory.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedFolderList


        Examples
        --------
        import datetime

        from merge import Merge
        from merge.resources.filestorage.resources.folders import (
            FoldersListRequestExpand,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.filestorage.folders.list(
            created_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            created_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            drive_id="drive_id",
            expand=FoldersListRequestExpand.DRIVE,
            include_deleted_data=True,
            include_remote_data=True,
            include_shell_data=True,
            modified_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            modified_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            name="name",
            page_size=1,
            parent_folder_id="parent_folder_id",
            remote_id="remote_id",
        )
        """
        _response = self._raw_client.list(
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            drive_id=drive_id,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            name=name,
            page_size=page_size,
            parent_folder_id=parent_folder_id,
            remote_id=remote_id,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        model: FolderRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FileStorageFolderResponse:
        """
        Creates a `Folder` object with the given values.

        Parameters
        ----------
        model : FolderRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileStorageFolderResponse


        Examples
        --------
        from merge import Merge
        from merge.resources.filestorage import FolderRequest

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.filestorage.folders.create(
            is_debug_mode=True,
            run_async=True,
            model=FolderRequest(),
        )
        """
        _response = self._raw_client.create(
            model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[FoldersRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Folder:
        """
        Returns a `Folder` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[FoldersRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Folder


        Examples
        --------
        from merge import Merge
        from merge.resources.filestorage.resources.folders import (
            FoldersRetrieveRequestExpand,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.filestorage.folders.retrieve(
            id="id",
            expand=FoldersRetrieveRequestExpand.DRIVE,
            include_remote_data=True,
            include_shell_data=True,
        )
        """
        _response = self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data

    def meta_post_retrieve(self, *, request_options: typing.Optional[RequestOptions] = None) -> MetaResponse:
        """
        Returns metadata for `FileStorageFolder` POSTs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.filestorage.folders.meta_post_retrieve()
        """
        _response = self._raw_client.meta_post_retrieve(request_options=request_options)
        return _response.data


class AsyncFoldersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFoldersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFoldersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFoldersClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        drive_id: typing.Optional[str] = None,
        expand: typing.Optional[FoldersListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        name: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        parent_folder_id: typing.Optional[str] = None,
        remote_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedFolderList:
        """
        Returns a list of `Folder` objects.

        Parameters
        ----------
        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        drive_id : typing.Optional[str]
            If provided, will only return folders in this drive.

        expand : typing.Optional[FoldersListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        name : typing.Optional[str]
            If provided, will only return folders with this name. This performs an exact match.

        page_size : typing.Optional[int]
            Number of results to return per page.

        parent_folder_id : typing.Optional[str]
            If provided, will only return folders in this parent folder. If null, will return folders in root directory.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedFolderList


        Examples
        --------
        import asyncio
        import datetime

        from merge import AsyncMerge
        from merge.resources.filestorage.resources.folders import (
            FoldersListRequestExpand,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.filestorage.folders.list(
                created_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                created_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
                drive_id="drive_id",
                expand=FoldersListRequestExpand.DRIVE,
                include_deleted_data=True,
                include_remote_data=True,
                include_shell_data=True,
                modified_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                modified_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                name="name",
                page_size=1,
                parent_folder_id="parent_folder_id",
                remote_id="remote_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            drive_id=drive_id,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            name=name,
            page_size=page_size,
            parent_folder_id=parent_folder_id,
            remote_id=remote_id,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        model: FolderRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FileStorageFolderResponse:
        """
        Creates a `Folder` object with the given values.

        Parameters
        ----------
        model : FolderRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileStorageFolderResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.filestorage import FolderRequest

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.filestorage.folders.create(
                is_debug_mode=True,
                run_async=True,
                model=FolderRequest(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    async def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[FoldersRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Folder:
        """
        Returns a `Folder` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[FoldersRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Folder


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.filestorage.resources.folders import (
            FoldersRetrieveRequestExpand,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.filestorage.folders.retrieve(
                id="id",
                expand=FoldersRetrieveRequestExpand.DRIVE,
                include_remote_data=True,
                include_shell_data=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data

    async def meta_post_retrieve(self, *, request_options: typing.Optional[RequestOptions] = None) -> MetaResponse:
        """
        Returns metadata for `FileStorageFolder` POSTs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.filestorage.folders.meta_post_retrieve()


        asyncio.run(main())
        """
        _response = await self._raw_client.meta_post_retrieve(request_options=request_options)
        return _response.data
