# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.request_options import RequestOptions
from .....core.unchecked_base_model import construct_type
from ...types.common_model_scope_api import CommonModelScopeApi
from ...types.individual_common_model_scope_deserializer_request import IndividualCommonModelScopeDeserializerRequest

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawScopesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def default_scopes_retrieve(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CommonModelScopeApi]:
        """
        Get the default permissions for Merge Common Models and fields across all Linked Accounts of a given category. [Learn more](https://help.merge.dev/en/articles/5950052-common-model-and-field-scopes).

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CommonModelScopeApi]

        """
        _response = self._client_wrapper.httpx_client.request(
            "filestorage/v1/default-scopes",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CommonModelScopeApi,
                    construct_type(
                        type_=CommonModelScopeApi,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def linked_account_scopes_retrieve(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CommonModelScopeApi]:
        """
        Get all available permissions for Merge Common Models and fields for a single Linked Account. [Learn more](https://help.merge.dev/en/articles/5950052-common-model-and-field-scopes).

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CommonModelScopeApi]

        """
        _response = self._client_wrapper.httpx_client.request(
            "filestorage/v1/linked-account-scopes",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CommonModelScopeApi,
                    construct_type(
                        type_=CommonModelScopeApi,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def linked_account_scopes_create(
        self,
        *,
        common_models: typing.Sequence[IndividualCommonModelScopeDeserializerRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CommonModelScopeApi]:
        """
        Update permissions for any Common Model or field for a single Linked Account. Any Scopes not set in this POST request will inherit the default Scopes. [Learn more](https://help.merge.dev/en/articles/5950052-common-model-and-field-scopes)

        Parameters
        ----------
        common_models : typing.Sequence[IndividualCommonModelScopeDeserializerRequest]
            The common models you want to update the scopes for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CommonModelScopeApi]

        """
        _response = self._client_wrapper.httpx_client.request(
            "filestorage/v1/linked-account-scopes",
            method="POST",
            json={
                "common_models": common_models,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CommonModelScopeApi,
                    construct_type(
                        type_=CommonModelScopeApi,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawScopesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def default_scopes_retrieve(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CommonModelScopeApi]:
        """
        Get the default permissions for Merge Common Models and fields across all Linked Accounts of a given category. [Learn more](https://help.merge.dev/en/articles/5950052-common-model-and-field-scopes).

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CommonModelScopeApi]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "filestorage/v1/default-scopes",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CommonModelScopeApi,
                    construct_type(
                        type_=CommonModelScopeApi,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def linked_account_scopes_retrieve(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CommonModelScopeApi]:
        """
        Get all available permissions for Merge Common Models and fields for a single Linked Account. [Learn more](https://help.merge.dev/en/articles/5950052-common-model-and-field-scopes).

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CommonModelScopeApi]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "filestorage/v1/linked-account-scopes",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CommonModelScopeApi,
                    construct_type(
                        type_=CommonModelScopeApi,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def linked_account_scopes_create(
        self,
        *,
        common_models: typing.Sequence[IndividualCommonModelScopeDeserializerRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CommonModelScopeApi]:
        """
        Update permissions for any Common Model or field for a single Linked Account. Any Scopes not set in this POST request will inherit the default Scopes. [Learn more](https://help.merge.dev/en/articles/5950052-common-model-and-field-scopes)

        Parameters
        ----------
        common_models : typing.Sequence[IndividualCommonModelScopeDeserializerRequest]
            The common models you want to update the scopes for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CommonModelScopeApi]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "filestorage/v1/linked-account-scopes",
            method="POST",
            json={
                "common_models": common_models,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CommonModelScopeApi,
                    construct_type(
                        type_=CommonModelScopeApi,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
