# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .folder_drive import FolderDrive
from .folder_permissions import FolderPermissions
from .remote_data import RemoteData


class Folder(UncheckedBaseModel):
    """
    # The Folder Object
    ### Description
    The `Folder` object is used to represent a collection of files and/or folders in the workspace. Could be within a drive, if it exists.
    ### Usage Example
    Fetch from the `GET /api/filestorage/v1/folders` endpoint and view their folders.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The folder's name.
    """

    folder_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL to access the folder.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The folder's size, in bytes.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The folder's description.
    """

    parent_folder: typing.Optional["FolderParentFolder"] = pydantic.Field(default=None)
    """
    The folder that the folder belongs to.
    """

    drive: typing.Optional[FolderDrive] = pydantic.Field(default=None)
    """
    The drive that the folder belongs to.
    """

    permissions: typing.Optional[FolderPermissions] = pydantic.Field(default=None)
    """
    The Permission object is used to represent a user's or group's access to a File or Folder. Permissions are unexpanded by default. Use the query param `expand=permissions` to see more details under `GET /folders`.
    """

    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's folder was created.
    """

    remote_updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's folder was updated.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .group import Group  # noqa: E402, F401, I001
from .folder_parent_folder import FolderParentFolder  # noqa: E402, F401, I001

update_forward_refs(Folder)
