# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .issue_status import IssueStatus


class Issue(UncheckedBaseModel):
    id: typing.Optional[str] = None
    status: typing.Optional[IssueStatus] = pydantic.Field(default=None)
    """
    Status of the issue. Options: ('ONGOING', 'RESOLVED')
    
    * `ONGOING` - ONGOING
    * `RESOLVED` - RESOLVED
    """

    error_description: str
    end_user: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    first_incident_time: typing.Optional[dt.datetime] = None
    last_incident_time: typing.Optional[dt.datetime] = None
    is_muted: typing.Optional[bool] = None
    error_details: typing.Optional[typing.List[str]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
