# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawHrisClient, RawHrisClient

if typing.TYPE_CHECKING:
    from .resources.account_details.client import AccountDetailsClient, AsyncAccountDetailsClient
    from .resources.account_token.client import AccountTokenClient, AsyncAccountTokenClient
    from .resources.async_passthrough.client import AsyncAsyncPassthroughClient
    from .resources.async_passthrough.client import (
        AsyncPassthroughClient as resources_hris_resources_async_passthrough_client_AsyncPassthroughClient,
    )
    from .resources.audit_trail.client import AsyncAuditTrailClient, AuditTrailClient
    from .resources.available_actions.client import AsyncAvailableActionsClient, AvailableActionsClient
    from .resources.bank_info.client import AsyncBankInfoClient, BankInfoClient
    from .resources.benefits.client import AsyncBenefitsClient, BenefitsClient
    from .resources.companies.client import AsyncCompaniesClient, CompaniesClient
    from .resources.delete_account.client import AsyncDeleteAccountClient, DeleteAccountClient
    from .resources.dependents.client import AsyncDependentsClient, DependentsClient
    from .resources.employee_payroll_runs.client import AsyncEmployeePayrollRunsClient, EmployeePayrollRunsClient
    from .resources.employees.client import AsyncEmployeesClient, EmployeesClient
    from .resources.employer_benefits.client import AsyncEmployerBenefitsClient, EmployerBenefitsClient
    from .resources.employments.client import AsyncEmploymentsClient, EmploymentsClient
    from .resources.field_mapping.client import AsyncFieldMappingClient, FieldMappingClient
    from .resources.force_resync.client import AsyncForceResyncClient, ForceResyncClient
    from .resources.generate_key.client import AsyncGenerateKeyClient, GenerateKeyClient
    from .resources.groups.client import AsyncGroupsClient, GroupsClient
    from .resources.issues.client import AsyncIssuesClient, IssuesClient
    from .resources.link_token.client import AsyncLinkTokenClient, LinkTokenClient
    from .resources.linked_accounts.client import AsyncLinkedAccountsClient, LinkedAccountsClient
    from .resources.locations.client import AsyncLocationsClient, LocationsClient
    from .resources.passthrough.client import (
        AsyncPassthroughClient as resources_hris_resources_passthrough_client_AsyncPassthroughClient,
    )
    from .resources.passthrough.client import PassthroughClient
    from .resources.pay_groups.client import AsyncPayGroupsClient, PayGroupsClient
    from .resources.payroll_runs.client import AsyncPayrollRunsClient, PayrollRunsClient
    from .resources.regenerate_key.client import AsyncRegenerateKeyClient, RegenerateKeyClient
    from .resources.scopes.client import AsyncScopesClient, ScopesClient
    from .resources.sync_status.client import AsyncSyncStatusClient, SyncStatusClient
    from .resources.teams.client import AsyncTeamsClient, TeamsClient
    from .resources.time_off.client import AsyncTimeOffClient, TimeOffClient
    from .resources.time_off_balances.client import AsyncTimeOffBalancesClient, TimeOffBalancesClient
    from .resources.timesheet_entries.client import AsyncTimesheetEntriesClient, TimesheetEntriesClient
    from .resources.webhook_receivers.client import AsyncWebhookReceiversClient, WebhookReceiversClient


class HrisClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawHrisClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._account_details: typing.Optional[AccountDetailsClient] = None
        self._account_token: typing.Optional[AccountTokenClient] = None
        self._async_passthrough: typing.Optional[
            resources_hris_resources_async_passthrough_client_AsyncPassthroughClient
        ] = None
        self._audit_trail: typing.Optional[AuditTrailClient] = None
        self._available_actions: typing.Optional[AvailableActionsClient] = None
        self._bank_info: typing.Optional[BankInfoClient] = None
        self._benefits: typing.Optional[BenefitsClient] = None
        self._companies: typing.Optional[CompaniesClient] = None
        self._scopes: typing.Optional[ScopesClient] = None
        self._delete_account: typing.Optional[DeleteAccountClient] = None
        self._dependents: typing.Optional[DependentsClient] = None
        self._employee_payroll_runs: typing.Optional[EmployeePayrollRunsClient] = None
        self._employees: typing.Optional[EmployeesClient] = None
        self._employer_benefits: typing.Optional[EmployerBenefitsClient] = None
        self._employments: typing.Optional[EmploymentsClient] = None
        self._field_mapping: typing.Optional[FieldMappingClient] = None
        self._generate_key: typing.Optional[GenerateKeyClient] = None
        self._groups: typing.Optional[GroupsClient] = None
        self._issues: typing.Optional[IssuesClient] = None
        self._link_token: typing.Optional[LinkTokenClient] = None
        self._linked_accounts: typing.Optional[LinkedAccountsClient] = None
        self._locations: typing.Optional[LocationsClient] = None
        self._passthrough: typing.Optional[PassthroughClient] = None
        self._pay_groups: typing.Optional[PayGroupsClient] = None
        self._payroll_runs: typing.Optional[PayrollRunsClient] = None
        self._regenerate_key: typing.Optional[RegenerateKeyClient] = None
        self._sync_status: typing.Optional[SyncStatusClient] = None
        self._force_resync: typing.Optional[ForceResyncClient] = None
        self._teams: typing.Optional[TeamsClient] = None
        self._time_off: typing.Optional[TimeOffClient] = None
        self._time_off_balances: typing.Optional[TimeOffBalancesClient] = None
        self._timesheet_entries: typing.Optional[TimesheetEntriesClient] = None
        self._webhook_receivers: typing.Optional[WebhookReceiversClient] = None

    @property
    def with_raw_response(self) -> RawHrisClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawHrisClient
        """
        return self._raw_client

    @property
    def account_details(self):
        if self._account_details is None:
            from .resources.account_details.client import AccountDetailsClient  # noqa: E402

            self._account_details = AccountDetailsClient(client_wrapper=self._client_wrapper)
        return self._account_details

    @property
    def account_token(self):
        if self._account_token is None:
            from .resources.account_token.client import AccountTokenClient  # noqa: E402

            self._account_token = AccountTokenClient(client_wrapper=self._client_wrapper)
        return self._account_token

    @property
    def async_passthrough(self):
        if self._async_passthrough is None:
            from .resources.async_passthrough.client import (
                AsyncPassthroughClient as resources_hris_resources_async_passthrough_client_AsyncPassthroughClient,  # noqa: E402
            )

            self._async_passthrough = resources_hris_resources_async_passthrough_client_AsyncPassthroughClient(
                client_wrapper=self._client_wrapper
            )
        return self._async_passthrough

    @property
    def audit_trail(self):
        if self._audit_trail is None:
            from .resources.audit_trail.client import AuditTrailClient  # noqa: E402

            self._audit_trail = AuditTrailClient(client_wrapper=self._client_wrapper)
        return self._audit_trail

    @property
    def available_actions(self):
        if self._available_actions is None:
            from .resources.available_actions.client import AvailableActionsClient  # noqa: E402

            self._available_actions = AvailableActionsClient(client_wrapper=self._client_wrapper)
        return self._available_actions

    @property
    def bank_info(self):
        if self._bank_info is None:
            from .resources.bank_info.client import BankInfoClient  # noqa: E402

            self._bank_info = BankInfoClient(client_wrapper=self._client_wrapper)
        return self._bank_info

    @property
    def benefits(self):
        if self._benefits is None:
            from .resources.benefits.client import BenefitsClient  # noqa: E402

            self._benefits = BenefitsClient(client_wrapper=self._client_wrapper)
        return self._benefits

    @property
    def companies(self):
        if self._companies is None:
            from .resources.companies.client import CompaniesClient  # noqa: E402

            self._companies = CompaniesClient(client_wrapper=self._client_wrapper)
        return self._companies

    @property
    def scopes(self):
        if self._scopes is None:
            from .resources.scopes.client import ScopesClient  # noqa: E402

            self._scopes = ScopesClient(client_wrapper=self._client_wrapper)
        return self._scopes

    @property
    def delete_account(self):
        if self._delete_account is None:
            from .resources.delete_account.client import DeleteAccountClient  # noqa: E402

            self._delete_account = DeleteAccountClient(client_wrapper=self._client_wrapper)
        return self._delete_account

    @property
    def dependents(self):
        if self._dependents is None:
            from .resources.dependents.client import DependentsClient  # noqa: E402

            self._dependents = DependentsClient(client_wrapper=self._client_wrapper)
        return self._dependents

    @property
    def employee_payroll_runs(self):
        if self._employee_payroll_runs is None:
            from .resources.employee_payroll_runs.client import EmployeePayrollRunsClient  # noqa: E402

            self._employee_payroll_runs = EmployeePayrollRunsClient(client_wrapper=self._client_wrapper)
        return self._employee_payroll_runs

    @property
    def employees(self):
        if self._employees is None:
            from .resources.employees.client import EmployeesClient  # noqa: E402

            self._employees = EmployeesClient(client_wrapper=self._client_wrapper)
        return self._employees

    @property
    def employer_benefits(self):
        if self._employer_benefits is None:
            from .resources.employer_benefits.client import EmployerBenefitsClient  # noqa: E402

            self._employer_benefits = EmployerBenefitsClient(client_wrapper=self._client_wrapper)
        return self._employer_benefits

    @property
    def employments(self):
        if self._employments is None:
            from .resources.employments.client import EmploymentsClient  # noqa: E402

            self._employments = EmploymentsClient(client_wrapper=self._client_wrapper)
        return self._employments

    @property
    def field_mapping(self):
        if self._field_mapping is None:
            from .resources.field_mapping.client import FieldMappingClient  # noqa: E402

            self._field_mapping = FieldMappingClient(client_wrapper=self._client_wrapper)
        return self._field_mapping

    @property
    def generate_key(self):
        if self._generate_key is None:
            from .resources.generate_key.client import GenerateKeyClient  # noqa: E402

            self._generate_key = GenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._generate_key

    @property
    def groups(self):
        if self._groups is None:
            from .resources.groups.client import GroupsClient  # noqa: E402

            self._groups = GroupsClient(client_wrapper=self._client_wrapper)
        return self._groups

    @property
    def issues(self):
        if self._issues is None:
            from .resources.issues.client import IssuesClient  # noqa: E402

            self._issues = IssuesClient(client_wrapper=self._client_wrapper)
        return self._issues

    @property
    def link_token(self):
        if self._link_token is None:
            from .resources.link_token.client import LinkTokenClient  # noqa: E402

            self._link_token = LinkTokenClient(client_wrapper=self._client_wrapper)
        return self._link_token

    @property
    def linked_accounts(self):
        if self._linked_accounts is None:
            from .resources.linked_accounts.client import LinkedAccountsClient  # noqa: E402

            self._linked_accounts = LinkedAccountsClient(client_wrapper=self._client_wrapper)
        return self._linked_accounts

    @property
    def locations(self):
        if self._locations is None:
            from .resources.locations.client import LocationsClient  # noqa: E402

            self._locations = LocationsClient(client_wrapper=self._client_wrapper)
        return self._locations

    @property
    def passthrough(self):
        if self._passthrough is None:
            from .resources.passthrough.client import PassthroughClient  # noqa: E402

            self._passthrough = PassthroughClient(client_wrapper=self._client_wrapper)
        return self._passthrough

    @property
    def pay_groups(self):
        if self._pay_groups is None:
            from .resources.pay_groups.client import PayGroupsClient  # noqa: E402

            self._pay_groups = PayGroupsClient(client_wrapper=self._client_wrapper)
        return self._pay_groups

    @property
    def payroll_runs(self):
        if self._payroll_runs is None:
            from .resources.payroll_runs.client import PayrollRunsClient  # noqa: E402

            self._payroll_runs = PayrollRunsClient(client_wrapper=self._client_wrapper)
        return self._payroll_runs

    @property
    def regenerate_key(self):
        if self._regenerate_key is None:
            from .resources.regenerate_key.client import RegenerateKeyClient  # noqa: E402

            self._regenerate_key = RegenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._regenerate_key

    @property
    def sync_status(self):
        if self._sync_status is None:
            from .resources.sync_status.client import SyncStatusClient  # noqa: E402

            self._sync_status = SyncStatusClient(client_wrapper=self._client_wrapper)
        return self._sync_status

    @property
    def force_resync(self):
        if self._force_resync is None:
            from .resources.force_resync.client import ForceResyncClient  # noqa: E402

            self._force_resync = ForceResyncClient(client_wrapper=self._client_wrapper)
        return self._force_resync

    @property
    def teams(self):
        if self._teams is None:
            from .resources.teams.client import TeamsClient  # noqa: E402

            self._teams = TeamsClient(client_wrapper=self._client_wrapper)
        return self._teams

    @property
    def time_off(self):
        if self._time_off is None:
            from .resources.time_off.client import TimeOffClient  # noqa: E402

            self._time_off = TimeOffClient(client_wrapper=self._client_wrapper)
        return self._time_off

    @property
    def time_off_balances(self):
        if self._time_off_balances is None:
            from .resources.time_off_balances.client import TimeOffBalancesClient  # noqa: E402

            self._time_off_balances = TimeOffBalancesClient(client_wrapper=self._client_wrapper)
        return self._time_off_balances

    @property
    def timesheet_entries(self):
        if self._timesheet_entries is None:
            from .resources.timesheet_entries.client import TimesheetEntriesClient  # noqa: E402

            self._timesheet_entries = TimesheetEntriesClient(client_wrapper=self._client_wrapper)
        return self._timesheet_entries

    @property
    def webhook_receivers(self):
        if self._webhook_receivers is None:
            from .resources.webhook_receivers.client import WebhookReceiversClient  # noqa: E402

            self._webhook_receivers = WebhookReceiversClient(client_wrapper=self._client_wrapper)
        return self._webhook_receivers


class AsyncHrisClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawHrisClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._account_details: typing.Optional[AsyncAccountDetailsClient] = None
        self._account_token: typing.Optional[AsyncAccountTokenClient] = None
        self._async_passthrough: typing.Optional[AsyncAsyncPassthroughClient] = None
        self._audit_trail: typing.Optional[AsyncAuditTrailClient] = None
        self._available_actions: typing.Optional[AsyncAvailableActionsClient] = None
        self._bank_info: typing.Optional[AsyncBankInfoClient] = None
        self._benefits: typing.Optional[AsyncBenefitsClient] = None
        self._companies: typing.Optional[AsyncCompaniesClient] = None
        self._scopes: typing.Optional[AsyncScopesClient] = None
        self._delete_account: typing.Optional[AsyncDeleteAccountClient] = None
        self._dependents: typing.Optional[AsyncDependentsClient] = None
        self._employee_payroll_runs: typing.Optional[AsyncEmployeePayrollRunsClient] = None
        self._employees: typing.Optional[AsyncEmployeesClient] = None
        self._employer_benefits: typing.Optional[AsyncEmployerBenefitsClient] = None
        self._employments: typing.Optional[AsyncEmploymentsClient] = None
        self._field_mapping: typing.Optional[AsyncFieldMappingClient] = None
        self._generate_key: typing.Optional[AsyncGenerateKeyClient] = None
        self._groups: typing.Optional[AsyncGroupsClient] = None
        self._issues: typing.Optional[AsyncIssuesClient] = None
        self._link_token: typing.Optional[AsyncLinkTokenClient] = None
        self._linked_accounts: typing.Optional[AsyncLinkedAccountsClient] = None
        self._locations: typing.Optional[AsyncLocationsClient] = None
        self._passthrough: typing.Optional[resources_hris_resources_passthrough_client_AsyncPassthroughClient] = None
        self._pay_groups: typing.Optional[AsyncPayGroupsClient] = None
        self._payroll_runs: typing.Optional[AsyncPayrollRunsClient] = None
        self._regenerate_key: typing.Optional[AsyncRegenerateKeyClient] = None
        self._sync_status: typing.Optional[AsyncSyncStatusClient] = None
        self._force_resync: typing.Optional[AsyncForceResyncClient] = None
        self._teams: typing.Optional[AsyncTeamsClient] = None
        self._time_off: typing.Optional[AsyncTimeOffClient] = None
        self._time_off_balances: typing.Optional[AsyncTimeOffBalancesClient] = None
        self._timesheet_entries: typing.Optional[AsyncTimesheetEntriesClient] = None
        self._webhook_receivers: typing.Optional[AsyncWebhookReceiversClient] = None

    @property
    def with_raw_response(self) -> AsyncRawHrisClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawHrisClient
        """
        return self._raw_client

    @property
    def account_details(self):
        if self._account_details is None:
            from .resources.account_details.client import AsyncAccountDetailsClient  # noqa: E402

            self._account_details = AsyncAccountDetailsClient(client_wrapper=self._client_wrapper)
        return self._account_details

    @property
    def account_token(self):
        if self._account_token is None:
            from .resources.account_token.client import AsyncAccountTokenClient  # noqa: E402

            self._account_token = AsyncAccountTokenClient(client_wrapper=self._client_wrapper)
        return self._account_token

    @property
    def async_passthrough(self):
        if self._async_passthrough is None:
            from .resources.async_passthrough.client import AsyncAsyncPassthroughClient  # noqa: E402

            self._async_passthrough = AsyncAsyncPassthroughClient(client_wrapper=self._client_wrapper)
        return self._async_passthrough

    @property
    def audit_trail(self):
        if self._audit_trail is None:
            from .resources.audit_trail.client import AsyncAuditTrailClient  # noqa: E402

            self._audit_trail = AsyncAuditTrailClient(client_wrapper=self._client_wrapper)
        return self._audit_trail

    @property
    def available_actions(self):
        if self._available_actions is None:
            from .resources.available_actions.client import AsyncAvailableActionsClient  # noqa: E402

            self._available_actions = AsyncAvailableActionsClient(client_wrapper=self._client_wrapper)
        return self._available_actions

    @property
    def bank_info(self):
        if self._bank_info is None:
            from .resources.bank_info.client import AsyncBankInfoClient  # noqa: E402

            self._bank_info = AsyncBankInfoClient(client_wrapper=self._client_wrapper)
        return self._bank_info

    @property
    def benefits(self):
        if self._benefits is None:
            from .resources.benefits.client import AsyncBenefitsClient  # noqa: E402

            self._benefits = AsyncBenefitsClient(client_wrapper=self._client_wrapper)
        return self._benefits

    @property
    def companies(self):
        if self._companies is None:
            from .resources.companies.client import AsyncCompaniesClient  # noqa: E402

            self._companies = AsyncCompaniesClient(client_wrapper=self._client_wrapper)
        return self._companies

    @property
    def scopes(self):
        if self._scopes is None:
            from .resources.scopes.client import AsyncScopesClient  # noqa: E402

            self._scopes = AsyncScopesClient(client_wrapper=self._client_wrapper)
        return self._scopes

    @property
    def delete_account(self):
        if self._delete_account is None:
            from .resources.delete_account.client import AsyncDeleteAccountClient  # noqa: E402

            self._delete_account = AsyncDeleteAccountClient(client_wrapper=self._client_wrapper)
        return self._delete_account

    @property
    def dependents(self):
        if self._dependents is None:
            from .resources.dependents.client import AsyncDependentsClient  # noqa: E402

            self._dependents = AsyncDependentsClient(client_wrapper=self._client_wrapper)
        return self._dependents

    @property
    def employee_payroll_runs(self):
        if self._employee_payroll_runs is None:
            from .resources.employee_payroll_runs.client import AsyncEmployeePayrollRunsClient  # noqa: E402

            self._employee_payroll_runs = AsyncEmployeePayrollRunsClient(client_wrapper=self._client_wrapper)
        return self._employee_payroll_runs

    @property
    def employees(self):
        if self._employees is None:
            from .resources.employees.client import AsyncEmployeesClient  # noqa: E402

            self._employees = AsyncEmployeesClient(client_wrapper=self._client_wrapper)
        return self._employees

    @property
    def employer_benefits(self):
        if self._employer_benefits is None:
            from .resources.employer_benefits.client import AsyncEmployerBenefitsClient  # noqa: E402

            self._employer_benefits = AsyncEmployerBenefitsClient(client_wrapper=self._client_wrapper)
        return self._employer_benefits

    @property
    def employments(self):
        if self._employments is None:
            from .resources.employments.client import AsyncEmploymentsClient  # noqa: E402

            self._employments = AsyncEmploymentsClient(client_wrapper=self._client_wrapper)
        return self._employments

    @property
    def field_mapping(self):
        if self._field_mapping is None:
            from .resources.field_mapping.client import AsyncFieldMappingClient  # noqa: E402

            self._field_mapping = AsyncFieldMappingClient(client_wrapper=self._client_wrapper)
        return self._field_mapping

    @property
    def generate_key(self):
        if self._generate_key is None:
            from .resources.generate_key.client import AsyncGenerateKeyClient  # noqa: E402

            self._generate_key = AsyncGenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._generate_key

    @property
    def groups(self):
        if self._groups is None:
            from .resources.groups.client import AsyncGroupsClient  # noqa: E402

            self._groups = AsyncGroupsClient(client_wrapper=self._client_wrapper)
        return self._groups

    @property
    def issues(self):
        if self._issues is None:
            from .resources.issues.client import AsyncIssuesClient  # noqa: E402

            self._issues = AsyncIssuesClient(client_wrapper=self._client_wrapper)
        return self._issues

    @property
    def link_token(self):
        if self._link_token is None:
            from .resources.link_token.client import AsyncLinkTokenClient  # noqa: E402

            self._link_token = AsyncLinkTokenClient(client_wrapper=self._client_wrapper)
        return self._link_token

    @property
    def linked_accounts(self):
        if self._linked_accounts is None:
            from .resources.linked_accounts.client import AsyncLinkedAccountsClient  # noqa: E402

            self._linked_accounts = AsyncLinkedAccountsClient(client_wrapper=self._client_wrapper)
        return self._linked_accounts

    @property
    def locations(self):
        if self._locations is None:
            from .resources.locations.client import AsyncLocationsClient  # noqa: E402

            self._locations = AsyncLocationsClient(client_wrapper=self._client_wrapper)
        return self._locations

    @property
    def passthrough(self):
        if self._passthrough is None:
            from .resources.passthrough.client import (
                AsyncPassthroughClient as resources_hris_resources_passthrough_client_AsyncPassthroughClient,  # noqa: E402
            )

            self._passthrough = resources_hris_resources_passthrough_client_AsyncPassthroughClient(
                client_wrapper=self._client_wrapper
            )
        return self._passthrough

    @property
    def pay_groups(self):
        if self._pay_groups is None:
            from .resources.pay_groups.client import AsyncPayGroupsClient  # noqa: E402

            self._pay_groups = AsyncPayGroupsClient(client_wrapper=self._client_wrapper)
        return self._pay_groups

    @property
    def payroll_runs(self):
        if self._payroll_runs is None:
            from .resources.payroll_runs.client import AsyncPayrollRunsClient  # noqa: E402

            self._payroll_runs = AsyncPayrollRunsClient(client_wrapper=self._client_wrapper)
        return self._payroll_runs

    @property
    def regenerate_key(self):
        if self._regenerate_key is None:
            from .resources.regenerate_key.client import AsyncRegenerateKeyClient  # noqa: E402

            self._regenerate_key = AsyncRegenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._regenerate_key

    @property
    def sync_status(self):
        if self._sync_status is None:
            from .resources.sync_status.client import AsyncSyncStatusClient  # noqa: E402

            self._sync_status = AsyncSyncStatusClient(client_wrapper=self._client_wrapper)
        return self._sync_status

    @property
    def force_resync(self):
        if self._force_resync is None:
            from .resources.force_resync.client import AsyncForceResyncClient  # noqa: E402

            self._force_resync = AsyncForceResyncClient(client_wrapper=self._client_wrapper)
        return self._force_resync

    @property
    def teams(self):
        if self._teams is None:
            from .resources.teams.client import AsyncTeamsClient  # noqa: E402

            self._teams = AsyncTeamsClient(client_wrapper=self._client_wrapper)
        return self._teams

    @property
    def time_off(self):
        if self._time_off is None:
            from .resources.time_off.client import AsyncTimeOffClient  # noqa: E402

            self._time_off = AsyncTimeOffClient(client_wrapper=self._client_wrapper)
        return self._time_off

    @property
    def time_off_balances(self):
        if self._time_off_balances is None:
            from .resources.time_off_balances.client import AsyncTimeOffBalancesClient  # noqa: E402

            self._time_off_balances = AsyncTimeOffBalancesClient(client_wrapper=self._client_wrapper)
        return self._time_off_balances

    @property
    def timesheet_entries(self):
        if self._timesheet_entries is None:
            from .resources.timesheet_entries.client import AsyncTimesheetEntriesClient  # noqa: E402

            self._timesheet_entries = AsyncTimesheetEntriesClient(client_wrapper=self._client_wrapper)
        return self._timesheet_entries

    @property
    def webhook_receivers(self):
        if self._webhook_receivers is None:
            from .resources.webhook_receivers.client import AsyncWebhookReceiversClient  # noqa: E402

            self._webhook_receivers = AsyncWebhookReceiversClient(client_wrapper=self._client_wrapper)
        return self._webhook_receivers
