# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.paginated_payroll_run_list import PaginatedPayrollRunList
from ...types.payroll_run import PayrollRun
from .raw_client import AsyncRawPayrollRunsClient, RawPayrollRunsClient
from .types.payroll_runs_list_request_remote_fields import PayrollRunsListRequestRemoteFields
from .types.payroll_runs_list_request_run_type import PayrollRunsListRequestRunType
from .types.payroll_runs_list_request_show_enum_origins import PayrollRunsListRequestShowEnumOrigins
from .types.payroll_runs_retrieve_request_remote_fields import PayrollRunsRetrieveRequestRemoteFields
from .types.payroll_runs_retrieve_request_show_enum_origins import PayrollRunsRetrieveRequestShowEnumOrigins


class PayrollRunsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPayrollRunsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPayrollRunsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPayrollRunsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        ended_after: typing.Optional[dt.datetime] = None,
        ended_before: typing.Optional[dt.datetime] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        remote_fields: typing.Optional[PayrollRunsListRequestRemoteFields] = None,
        remote_id: typing.Optional[str] = None,
        run_type: typing.Optional[PayrollRunsListRequestRunType] = None,
        show_enum_origins: typing.Optional[PayrollRunsListRequestShowEnumOrigins] = None,
        started_after: typing.Optional[dt.datetime] = None,
        started_before: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedPayrollRunList:
        """
        Returns a list of `PayrollRun` objects.

        Parameters
        ----------
        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        ended_after : typing.Optional[dt.datetime]
            If provided, will only return payroll runs ended after this datetime.

        ended_before : typing.Optional[dt.datetime]
            If provided, will only return payroll runs ended before this datetime.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        remote_fields : typing.Optional[PayrollRunsListRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        run_type : typing.Optional[PayrollRunsListRequestRunType]
            If provided, will only return PayrollRun's with this status. Options: ('REGULAR', 'OFF_CYCLE', 'CORRECTION', 'TERMINATION', 'SIGN_ON_BONUS')

            * `REGULAR` - REGULAR
            * `OFF_CYCLE` - OFF_CYCLE
            * `CORRECTION` - CORRECTION
            * `TERMINATION` - TERMINATION
            * `SIGN_ON_BONUS` - SIGN_ON_BONUS

        show_enum_origins : typing.Optional[PayrollRunsListRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        started_after : typing.Optional[dt.datetime]
            If provided, will only return payroll runs started after this datetime.

        started_before : typing.Optional[dt.datetime]
            If provided, will only return payroll runs started before this datetime.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedPayrollRunList


        Examples
        --------
        import datetime

        from merge import Merge
        from merge.resources.hris.resources.payroll_runs import (
            PayrollRunsListRequestRemoteFields,
            PayrollRunsListRequestRunType,
            PayrollRunsListRequestShowEnumOrigins,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.hris.payroll_runs.list(
            created_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            created_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            ended_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            ended_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            include_deleted_data=True,
            include_remote_data=True,
            include_shell_data=True,
            modified_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            modified_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            page_size=1,
            remote_fields=PayrollRunsListRequestRemoteFields.RUN_STATE,
            remote_id="remote_id",
            run_type=PayrollRunsListRequestRunType.CORRECTION,
            show_enum_origins=PayrollRunsListRequestShowEnumOrigins.RUN_STATE,
            started_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            started_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
        )
        """
        _response = self._raw_client.list(
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            ended_after=ended_after,
            ended_before=ended_before,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            remote_fields=remote_fields,
            remote_id=remote_id,
            run_type=run_type,
            show_enum_origins=show_enum_origins,
            started_after=started_after,
            started_before=started_before,
            request_options=request_options,
        )
        return _response.data

    def retrieve(
        self,
        id: str,
        *,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        remote_fields: typing.Optional[PayrollRunsRetrieveRequestRemoteFields] = None,
        show_enum_origins: typing.Optional[PayrollRunsRetrieveRequestShowEnumOrigins] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PayrollRun:
        """
        Returns a `PayrollRun` object with the given `id`.

        Parameters
        ----------
        id : str

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        remote_fields : typing.Optional[PayrollRunsRetrieveRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        show_enum_origins : typing.Optional[PayrollRunsRetrieveRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PayrollRun


        Examples
        --------
        from merge import Merge
        from merge.resources.hris.resources.payroll_runs import (
            PayrollRunsRetrieveRequestRemoteFields,
            PayrollRunsRetrieveRequestShowEnumOrigins,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.hris.payroll_runs.retrieve(
            id="id",
            include_remote_data=True,
            include_shell_data=True,
            remote_fields=PayrollRunsRetrieveRequestRemoteFields.RUN_STATE,
            show_enum_origins=PayrollRunsRetrieveRequestShowEnumOrigins.RUN_STATE,
        )
        """
        _response = self._raw_client.retrieve(
            id,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            remote_fields=remote_fields,
            show_enum_origins=show_enum_origins,
            request_options=request_options,
        )
        return _response.data


class AsyncPayrollRunsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPayrollRunsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPayrollRunsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPayrollRunsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        ended_after: typing.Optional[dt.datetime] = None,
        ended_before: typing.Optional[dt.datetime] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        remote_fields: typing.Optional[PayrollRunsListRequestRemoteFields] = None,
        remote_id: typing.Optional[str] = None,
        run_type: typing.Optional[PayrollRunsListRequestRunType] = None,
        show_enum_origins: typing.Optional[PayrollRunsListRequestShowEnumOrigins] = None,
        started_after: typing.Optional[dt.datetime] = None,
        started_before: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedPayrollRunList:
        """
        Returns a list of `PayrollRun` objects.

        Parameters
        ----------
        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        ended_after : typing.Optional[dt.datetime]
            If provided, will only return payroll runs ended after this datetime.

        ended_before : typing.Optional[dt.datetime]
            If provided, will only return payroll runs ended before this datetime.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        remote_fields : typing.Optional[PayrollRunsListRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        run_type : typing.Optional[PayrollRunsListRequestRunType]
            If provided, will only return PayrollRun's with this status. Options: ('REGULAR', 'OFF_CYCLE', 'CORRECTION', 'TERMINATION', 'SIGN_ON_BONUS')

            * `REGULAR` - REGULAR
            * `OFF_CYCLE` - OFF_CYCLE
            * `CORRECTION` - CORRECTION
            * `TERMINATION` - TERMINATION
            * `SIGN_ON_BONUS` - SIGN_ON_BONUS

        show_enum_origins : typing.Optional[PayrollRunsListRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        started_after : typing.Optional[dt.datetime]
            If provided, will only return payroll runs started after this datetime.

        started_before : typing.Optional[dt.datetime]
            If provided, will only return payroll runs started before this datetime.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedPayrollRunList


        Examples
        --------
        import asyncio
        import datetime

        from merge import AsyncMerge
        from merge.resources.hris.resources.payroll_runs import (
            PayrollRunsListRequestRemoteFields,
            PayrollRunsListRequestRunType,
            PayrollRunsListRequestShowEnumOrigins,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.hris.payroll_runs.list(
                created_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                created_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
                ended_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                ended_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                include_deleted_data=True,
                include_remote_data=True,
                include_shell_data=True,
                modified_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                modified_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                page_size=1,
                remote_fields=PayrollRunsListRequestRemoteFields.RUN_STATE,
                remote_id="remote_id",
                run_type=PayrollRunsListRequestRunType.CORRECTION,
                show_enum_origins=PayrollRunsListRequestShowEnumOrigins.RUN_STATE,
                started_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                started_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            ended_after=ended_after,
            ended_before=ended_before,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            remote_fields=remote_fields,
            remote_id=remote_id,
            run_type=run_type,
            show_enum_origins=show_enum_origins,
            started_after=started_after,
            started_before=started_before,
            request_options=request_options,
        )
        return _response.data

    async def retrieve(
        self,
        id: str,
        *,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        remote_fields: typing.Optional[PayrollRunsRetrieveRequestRemoteFields] = None,
        show_enum_origins: typing.Optional[PayrollRunsRetrieveRequestShowEnumOrigins] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PayrollRun:
        """
        Returns a `PayrollRun` object with the given `id`.

        Parameters
        ----------
        id : str

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        remote_fields : typing.Optional[PayrollRunsRetrieveRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        show_enum_origins : typing.Optional[PayrollRunsRetrieveRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PayrollRun


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.hris.resources.payroll_runs import (
            PayrollRunsRetrieveRequestRemoteFields,
            PayrollRunsRetrieveRequestShowEnumOrigins,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.hris.payroll_runs.retrieve(
                id="id",
                include_remote_data=True,
                include_shell_data=True,
                remote_fields=PayrollRunsRetrieveRequestRemoteFields.RUN_STATE,
                show_enum_origins=PayrollRunsRetrieveRequestShowEnumOrigins.RUN_STATE,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(
            id,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            remote_fields=remote_fields,
            show_enum_origins=show_enum_origins,
            request_options=request_options,
        )
        return _response.data
