# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.meta_response import MetaResponse
from ...types.paginated_time_off_list import PaginatedTimeOffList
from ...types.time_off import TimeOff
from ...types.time_off_request import TimeOffRequest
from ...types.time_off_response import TimeOffResponse
from .raw_client import AsyncRawTimeOffClient, RawTimeOffClient
from .types.time_off_list_request_expand import TimeOffListRequestExpand
from .types.time_off_list_request_remote_fields import TimeOffListRequestRemoteFields
from .types.time_off_list_request_request_type import TimeOffListRequestRequestType
from .types.time_off_list_request_show_enum_origins import TimeOffListRequestShowEnumOrigins
from .types.time_off_list_request_status import TimeOffListRequestStatus
from .types.time_off_retrieve_request_expand import TimeOffRetrieveRequestExpand
from .types.time_off_retrieve_request_remote_fields import TimeOffRetrieveRequestRemoteFields
from .types.time_off_retrieve_request_show_enum_origins import TimeOffRetrieveRequestShowEnumOrigins

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TimeOffClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTimeOffClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTimeOffClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTimeOffClient
        """
        return self._raw_client

    def list(
        self,
        *,
        approver_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        employee_id: typing.Optional[str] = None,
        ended_after: typing.Optional[dt.datetime] = None,
        ended_before: typing.Optional[dt.datetime] = None,
        expand: typing.Optional[TimeOffListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        remote_fields: typing.Optional[TimeOffListRequestRemoteFields] = None,
        remote_id: typing.Optional[str] = None,
        request_type: typing.Optional[TimeOffListRequestRequestType] = None,
        show_enum_origins: typing.Optional[TimeOffListRequestShowEnumOrigins] = None,
        started_after: typing.Optional[dt.datetime] = None,
        started_before: typing.Optional[dt.datetime] = None,
        status: typing.Optional[TimeOffListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedTimeOffList:
        """
        Returns a list of `TimeOff` objects.

        Parameters
        ----------
        approver_id : typing.Optional[str]
            If provided, will only return time off for this approver.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        employee_id : typing.Optional[str]
            If provided, will only return time off for this employee.

        ended_after : typing.Optional[dt.datetime]
            If provided, will only return employees that ended after this datetime.

        ended_before : typing.Optional[dt.datetime]
            If provided, will only return time-offs that ended before this datetime.

        expand : typing.Optional[TimeOffListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        remote_fields : typing.Optional[TimeOffListRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_type : typing.Optional[TimeOffListRequestRequestType]
            If provided, will only return TimeOff with this request type. Options: ('VACATION', 'SICK', 'PERSONAL', 'JURY_DUTY', 'VOLUNTEER', 'BEREAVEMENT')

            * `VACATION` - VACATION
            * `SICK` - SICK
            * `PERSONAL` - PERSONAL
            * `JURY_DUTY` - JURY_DUTY
            * `VOLUNTEER` - VOLUNTEER
            * `BEREAVEMENT` - BEREAVEMENT

        show_enum_origins : typing.Optional[TimeOffListRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        started_after : typing.Optional[dt.datetime]
            If provided, will only return time-offs that started after this datetime.

        started_before : typing.Optional[dt.datetime]
            If provided, will only return time-offs that started before this datetime.

        status : typing.Optional[TimeOffListRequestStatus]
            If provided, will only return TimeOff with this status. Options: ('REQUESTED', 'APPROVED', 'DECLINED', 'CANCELLED', 'DELETED')

            * `REQUESTED` - REQUESTED
            * `APPROVED` - APPROVED
            * `DECLINED` - DECLINED
            * `CANCELLED` - CANCELLED
            * `DELETED` - DELETED

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedTimeOffList


        Examples
        --------
        import datetime

        from merge import Merge
        from merge.resources.hris.resources.time_off import (
            TimeOffListRequestExpand,
            TimeOffListRequestRemoteFields,
            TimeOffListRequestRequestType,
            TimeOffListRequestShowEnumOrigins,
            TimeOffListRequestStatus,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.hris.time_off.list(
            approver_id="approver_id",
            created_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            created_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            employee_id="employee_id",
            ended_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            ended_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            expand=TimeOffListRequestExpand.APPROVER,
            include_deleted_data=True,
            include_remote_data=True,
            include_shell_data=True,
            modified_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            modified_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            page_size=1,
            remote_fields=TimeOffListRequestRemoteFields.REQUEST_TYPE,
            remote_id="remote_id",
            request_type=TimeOffListRequestRequestType.BEREAVEMENT,
            show_enum_origins=TimeOffListRequestShowEnumOrigins.REQUEST_TYPE,
            started_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            started_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            status=TimeOffListRequestStatus.APPROVED,
        )
        """
        _response = self._raw_client.list(
            approver_id=approver_id,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            employee_id=employee_id,
            ended_after=ended_after,
            ended_before=ended_before,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            remote_fields=remote_fields,
            remote_id=remote_id,
            request_type=request_type,
            show_enum_origins=show_enum_origins,
            started_after=started_after,
            started_before=started_before,
            status=status,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        model: TimeOffRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TimeOffResponse:
        """
        Creates a `TimeOff` object with the given values.

        Parameters
        ----------
        model : TimeOffRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TimeOffResponse


        Examples
        --------
        from merge import Merge
        from merge.resources.hris import TimeOffRequest

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.hris.time_off.create(
            is_debug_mode=True,
            run_async=True,
            model=TimeOffRequest(),
        )
        """
        _response = self._raw_client.create(
            model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[TimeOffRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        remote_fields: typing.Optional[TimeOffRetrieveRequestRemoteFields] = None,
        show_enum_origins: typing.Optional[TimeOffRetrieveRequestShowEnumOrigins] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TimeOff:
        """
        Returns a `TimeOff` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[TimeOffRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        remote_fields : typing.Optional[TimeOffRetrieveRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        show_enum_origins : typing.Optional[TimeOffRetrieveRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TimeOff


        Examples
        --------
        from merge import Merge
        from merge.resources.hris.resources.time_off import (
            TimeOffRetrieveRequestExpand,
            TimeOffRetrieveRequestRemoteFields,
            TimeOffRetrieveRequestShowEnumOrigins,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.hris.time_off.retrieve(
            id="id",
            expand=TimeOffRetrieveRequestExpand.APPROVER,
            include_remote_data=True,
            include_shell_data=True,
            remote_fields=TimeOffRetrieveRequestRemoteFields.REQUEST_TYPE,
            show_enum_origins=TimeOffRetrieveRequestShowEnumOrigins.REQUEST_TYPE,
        )
        """
        _response = self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            remote_fields=remote_fields,
            show_enum_origins=show_enum_origins,
            request_options=request_options,
        )
        return _response.data

    def meta_post_retrieve(self, *, request_options: typing.Optional[RequestOptions] = None) -> MetaResponse:
        """
        Returns metadata for `TimeOff` POSTs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.hris.time_off.meta_post_retrieve()
        """
        _response = self._raw_client.meta_post_retrieve(request_options=request_options)
        return _response.data


class AsyncTimeOffClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTimeOffClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTimeOffClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTimeOffClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        approver_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        employee_id: typing.Optional[str] = None,
        ended_after: typing.Optional[dt.datetime] = None,
        ended_before: typing.Optional[dt.datetime] = None,
        expand: typing.Optional[TimeOffListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        remote_fields: typing.Optional[TimeOffListRequestRemoteFields] = None,
        remote_id: typing.Optional[str] = None,
        request_type: typing.Optional[TimeOffListRequestRequestType] = None,
        show_enum_origins: typing.Optional[TimeOffListRequestShowEnumOrigins] = None,
        started_after: typing.Optional[dt.datetime] = None,
        started_before: typing.Optional[dt.datetime] = None,
        status: typing.Optional[TimeOffListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedTimeOffList:
        """
        Returns a list of `TimeOff` objects.

        Parameters
        ----------
        approver_id : typing.Optional[str]
            If provided, will only return time off for this approver.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        employee_id : typing.Optional[str]
            If provided, will only return time off for this employee.

        ended_after : typing.Optional[dt.datetime]
            If provided, will only return employees that ended after this datetime.

        ended_before : typing.Optional[dt.datetime]
            If provided, will only return time-offs that ended before this datetime.

        expand : typing.Optional[TimeOffListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        remote_fields : typing.Optional[TimeOffListRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_type : typing.Optional[TimeOffListRequestRequestType]
            If provided, will only return TimeOff with this request type. Options: ('VACATION', 'SICK', 'PERSONAL', 'JURY_DUTY', 'VOLUNTEER', 'BEREAVEMENT')

            * `VACATION` - VACATION
            * `SICK` - SICK
            * `PERSONAL` - PERSONAL
            * `JURY_DUTY` - JURY_DUTY
            * `VOLUNTEER` - VOLUNTEER
            * `BEREAVEMENT` - BEREAVEMENT

        show_enum_origins : typing.Optional[TimeOffListRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        started_after : typing.Optional[dt.datetime]
            If provided, will only return time-offs that started after this datetime.

        started_before : typing.Optional[dt.datetime]
            If provided, will only return time-offs that started before this datetime.

        status : typing.Optional[TimeOffListRequestStatus]
            If provided, will only return TimeOff with this status. Options: ('REQUESTED', 'APPROVED', 'DECLINED', 'CANCELLED', 'DELETED')

            * `REQUESTED` - REQUESTED
            * `APPROVED` - APPROVED
            * `DECLINED` - DECLINED
            * `CANCELLED` - CANCELLED
            * `DELETED` - DELETED

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedTimeOffList


        Examples
        --------
        import asyncio
        import datetime

        from merge import AsyncMerge
        from merge.resources.hris.resources.time_off import (
            TimeOffListRequestExpand,
            TimeOffListRequestRemoteFields,
            TimeOffListRequestRequestType,
            TimeOffListRequestShowEnumOrigins,
            TimeOffListRequestStatus,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.hris.time_off.list(
                approver_id="approver_id",
                created_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                created_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
                employee_id="employee_id",
                ended_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                ended_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                expand=TimeOffListRequestExpand.APPROVER,
                include_deleted_data=True,
                include_remote_data=True,
                include_shell_data=True,
                modified_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                modified_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                page_size=1,
                remote_fields=TimeOffListRequestRemoteFields.REQUEST_TYPE,
                remote_id="remote_id",
                request_type=TimeOffListRequestRequestType.BEREAVEMENT,
                show_enum_origins=TimeOffListRequestShowEnumOrigins.REQUEST_TYPE,
                started_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                started_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                status=TimeOffListRequestStatus.APPROVED,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            approver_id=approver_id,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            employee_id=employee_id,
            ended_after=ended_after,
            ended_before=ended_before,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            remote_fields=remote_fields,
            remote_id=remote_id,
            request_type=request_type,
            show_enum_origins=show_enum_origins,
            started_after=started_after,
            started_before=started_before,
            status=status,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        model: TimeOffRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TimeOffResponse:
        """
        Creates a `TimeOff` object with the given values.

        Parameters
        ----------
        model : TimeOffRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TimeOffResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.hris import TimeOffRequest

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.hris.time_off.create(
                is_debug_mode=True,
                run_async=True,
                model=TimeOffRequest(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    async def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[TimeOffRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        remote_fields: typing.Optional[TimeOffRetrieveRequestRemoteFields] = None,
        show_enum_origins: typing.Optional[TimeOffRetrieveRequestShowEnumOrigins] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TimeOff:
        """
        Returns a `TimeOff` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[TimeOffRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        remote_fields : typing.Optional[TimeOffRetrieveRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        show_enum_origins : typing.Optional[TimeOffRetrieveRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TimeOff


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.hris.resources.time_off import (
            TimeOffRetrieveRequestExpand,
            TimeOffRetrieveRequestRemoteFields,
            TimeOffRetrieveRequestShowEnumOrigins,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.hris.time_off.retrieve(
                id="id",
                expand=TimeOffRetrieveRequestExpand.APPROVER,
                include_remote_data=True,
                include_shell_data=True,
                remote_fields=TimeOffRetrieveRequestRemoteFields.REQUEST_TYPE,
                show_enum_origins=TimeOffRetrieveRequestShowEnumOrigins.REQUEST_TYPE,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            remote_fields=remote_fields,
            show_enum_origins=show_enum_origins,
            request_options=request_options,
        )
        return _response.data

    async def meta_post_retrieve(self, *, request_options: typing.Optional[RequestOptions] = None) -> MetaResponse:
        """
        Returns metadata for `TimeOff` POSTs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.hris.time_off.meta_post_retrieve()


        asyncio.run(main())
        """
        _response = await self._raw_client.meta_post_retrieve(request_options=request_options)
        return _response.data
