# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .method_enum import MethodEnum
from .multipart_form_field_request import MultipartFormFieldRequest
from .request_format_enum import RequestFormatEnum


class DataPassthroughRequest(UncheckedBaseModel):
    """
    # The DataPassthrough Object
    ### Description
    The `DataPassthrough` object is used to send information to an otherwise-unsupported third-party endpoint.

    ### Usage Example
    Create a `DataPassthrough` to get team hierarchies from your Rippling integration.
    """

    method: MethodEnum
    path: str = pydantic.Field()
    """
    The path of the request in the third party's platform.
    """

    base_url_override: typing.Optional[str] = pydantic.Field(default=None)
    """
    An optional override of the third party's base url for the request.
    """

    data: typing.Optional[str] = pydantic.Field(default=None)
    """
    The data with the request. You must include a `request_format` parameter matching the data's format
    """

    multipart_form_data: typing.Optional[typing.List[MultipartFormFieldRequest]] = pydantic.Field(default=None)
    """
    Pass an array of `MultipartFormField` objects in here instead of using the `data` param if `request_format` is set to `MULTIPART`.
    """

    headers: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The headers to use for the request (Merge will handle the account's authorization headers). `Content-Type` header is required for passthrough. Choose content type corresponding to expected format of receiving server.
    """

    request_format: typing.Optional[RequestFormatEnum] = None
    normalize_response: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Optional. If true, the response will always be an object of the form `{"type": T, "value": ...}` where `T` will be one of `string, boolean, number, null, array, object`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
