# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .employee_company import EmployeeCompany
from .employee_employment_status import EmployeeEmploymentStatus
from .employee_ethnicity import EmployeeEthnicity
from .employee_gender import EmployeeGender
from .employee_groups_item import EmployeeGroupsItem
from .employee_home_location import EmployeeHomeLocation
from .employee_marital_status import EmployeeMaritalStatus
from .employee_pay_group import EmployeePayGroup
from .employee_team import EmployeeTeam
from .employee_work_location import EmployeeWorkLocation
from .remote_data import RemoteData


class Employee(UncheckedBaseModel):
    """
    # The Employee Object
    ### Description
    The `Employee` object is used to represent any person who has been employed by a company. By default, it returns all employees. To filter for only active employees, set the `employment_status` query parameter to `ACTIVE`.

    ### Usage Example
    Fetch from the `LIST Employee` endpoint and filter by `ID` to show all employees.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    employee_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's number that appears in the third-party integration's UI.
    """

    company: typing.Optional[EmployeeCompany] = pydantic.Field(default=None)
    """
    The ID of the employee's company.
    """

    first_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's first name.
    """

    last_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's last name.
    """

    preferred_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's preferred first name.
    """

    display_full_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's full name, to use for display purposes. If a preferred first name is available, the full name will include the preferred first name.
    """

    username: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's username that appears in the remote UI.
    """

    groups: typing.Optional[typing.List[typing.Optional[EmployeeGroupsItem]]] = None
    work_email: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's work email.
    """

    personal_email: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's personal email.
    """

    mobile_phone_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's mobile phone number.
    """

    employments: typing.Optional[typing.List[typing.Optional["EmployeeEmploymentsItem"]]] = pydantic.Field(default=None)
    """
    Array of `Employment` IDs for this Employee.
    """

    home_location: typing.Optional[EmployeeHomeLocation] = pydantic.Field(default=None)
    """
    The employee's home address.
    """

    work_location: typing.Optional[EmployeeWorkLocation] = pydantic.Field(default=None)
    """
    The employee's work address.
    """

    manager: typing.Optional["EmployeeManager"] = pydantic.Field(default=None)
    """
    The employee ID of the employee's manager.
    """

    team: typing.Optional[EmployeeTeam] = pydantic.Field(default=None)
    """
    The employee's team.
    """

    pay_group: typing.Optional[EmployeePayGroup] = pydantic.Field(default=None)
    """
    The employee's pay group
    """

    ssn: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's social security number.
    """

    gender: typing.Optional[EmployeeGender] = pydantic.Field(default=None)
    """
    The employee's gender.
    
    * `MALE` - MALE
    * `FEMALE` - FEMALE
    * `NON-BINARY` - NON-BINARY
    * `OTHER` - OTHER
    * `PREFER_NOT_TO_DISCLOSE` - PREFER_NOT_TO_DISCLOSE
    """

    ethnicity: typing.Optional[EmployeeEthnicity] = pydantic.Field(default=None)
    """
    The employee's ethnicity.
    
    * `AMERICAN_INDIAN_OR_ALASKA_NATIVE` - AMERICAN_INDIAN_OR_ALASKA_NATIVE
    * `ASIAN_OR_INDIAN_SUBCONTINENT` - ASIAN_OR_INDIAN_SUBCONTINENT
    * `BLACK_OR_AFRICAN_AMERICAN` - BLACK_OR_AFRICAN_AMERICAN
    * `HISPANIC_OR_LATINO` - HISPANIC_OR_LATINO
    * `NATIVE_HAWAIIAN_OR_OTHER_PACIFIC_ISLANDER` - NATIVE_HAWAIIAN_OR_OTHER_PACIFIC_ISLANDER
    * `TWO_OR_MORE_RACES` - TWO_OR_MORE_RACES
    * `WHITE` - WHITE
    * `PREFER_NOT_TO_DISCLOSE` - PREFER_NOT_TO_DISCLOSE
    """

    marital_status: typing.Optional[EmployeeMaritalStatus] = pydantic.Field(default=None)
    """
    The employee's filing status as related to marital status.
    
    * `SINGLE` - SINGLE
    * `MARRIED_FILING_JOINTLY` - MARRIED_FILING_JOINTLY
    * `MARRIED_FILING_SEPARATELY` - MARRIED_FILING_SEPARATELY
    * `HEAD_OF_HOUSEHOLD` - HEAD_OF_HOUSEHOLD
    * `QUALIFYING_WIDOW_OR_WIDOWER_WITH_DEPENDENT_CHILD` - QUALIFYING_WIDOW_OR_WIDOWER_WITH_DEPENDENT_CHILD
    """

    date_of_birth: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The employee's date of birth.
    """

    hire_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date that the employee was hired, usually the day that an offer letter is signed. If an employee has multiple hire dates from previous employments, this represents the most recent hire date. Note: If you're looking for the employee's start date, refer to the start_date field.
    """

    start_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date that the employee started working. If an employee was rehired, the most recent start date will be returned.
    """

    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's employee was created.
    """

    employment_status: typing.Optional[EmployeeEmploymentStatus] = pydantic.Field(default=None)
    """
    The employment status of the employee.
    
    * `ACTIVE` - ACTIVE
    * `PENDING` - PENDING
    * `INACTIVE` - INACTIVE
    """

    termination_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The employee's termination date.
    """

    avatar: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL of the employee's avatar image.
    """

    custom_fields: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Custom fields configured for a given model.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .employment import Employment  # noqa: E402, F401, I001
from .team import Team  # noqa: E402, F401, I001
from .employee_employments_item import EmployeeEmploymentsItem  # noqa: E402, F401, I001
from .employee_manager import EmployeeManager  # noqa: E402, F401, I001

update_forward_refs(Employee)
