# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .employer_benefit_benefit_plan_type import EmployerBenefitBenefitPlanType
from .remote_data import RemoteData


class EmployerBenefit(UncheckedBaseModel):
    """
    # The EmployerBenefit Object
    ### Description
    The `Employer Benefit` object is used to represent a benefit plan offered by a company.

    ### Usage Example
    Fetch from the `LIST EmployerBenefits` endpoint and filter by `ID` to show all EmployerBenefits.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    benefit_plan_type: typing.Optional[EmployerBenefitBenefitPlanType] = pydantic.Field(default=None)
    """
    The type of benefit plan.
    
    * `MEDICAL` - MEDICAL
    * `HEALTH_SAVINGS` - HEALTH_SAVINGS
    * `INSURANCE` - INSURANCE
    * `RETIREMENT` - RETIREMENT
    * `OTHER` - OTHER
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employer benefit's name - typically the carrier or network name.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employer benefit's description.
    """

    deduction_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employer benefit's deduction code.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
