# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .group_type import GroupType
from .remote_data import RemoteData


class Group(UncheckedBaseModel):
    """
    # The Group Object
    ### Description
    The `Group` object is used to represent any subset of employees across, for example, `DEPARTMENT` or `TEAM`. Employees can be in multiple Groups.

    ### Usage Example
    Fetch from the `LIST Employee` endpoint and expand groups to view an employee's groups.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    parent_group: typing.Optional[str] = pydantic.Field(default=None)
    """
    The parent group for this group.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The group name.
    """

    type: typing.Optional[GroupType] = pydantic.Field(default=None)
    """
    The Group type returned directly from the third-party.
    
    * `TEAM` - TEAM
    * `DEPARTMENT` - DEPARTMENT
    * `COST_CENTER` - COST_CENTER
    * `BUSINESS_UNIT` - BUSINESS_UNIT
    * `GROUP` - GROUP
    """

    is_commonly_used_as_team: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether the Group refers to a team in the third party platform. Note that this is an opinionated view based on how Merge observes most organizations representing teams in each third party platform. If your customer uses a platform different from most, there is a chance this will not be correct.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
