# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .payroll_run_run_state import PayrollRunRunState
from .payroll_run_run_type import PayrollRunRunType
from .remote_data import RemoteData


class PayrollRun(UncheckedBaseModel):
    """
    # The PayrollRun Object
    ### Description
    The `PayrollRun` object is used to represent a group of pay statements for a specific pay schedule.

    ### Usage Example
    Fetch from the `LIST PayrollRuns` endpoint and filter by `ID` to show all payroll runs.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    run_state: typing.Optional[PayrollRunRunState] = pydantic.Field(default=None)
    """
    The state of the payroll run
    
    * `PAID` - PAID
    * `DRAFT` - DRAFT
    * `APPROVED` - APPROVED
    * `FAILED` - FAILED
    * `CLOSED` - CLOSED
    """

    run_type: typing.Optional[PayrollRunRunType] = pydantic.Field(default=None)
    """
    The type of the payroll run
    
    * `REGULAR` - REGULAR
    * `OFF_CYCLE` - OFF_CYCLE
    * `CORRECTION` - CORRECTION
    * `TERMINATION` - TERMINATION
    * `SIGN_ON_BONUS` - SIGN_ON_BONUS
    """

    start_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The day and time the payroll run started.
    """

    end_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The day and time the payroll run ended.
    """

    check_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The day and time the payroll run was checked.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
