# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .time_off_request_approver import TimeOffRequestApprover
from .time_off_request_employee import TimeOffRequestEmployee
from .time_off_request_request_type import TimeOffRequestRequestType
from .time_off_request_status import TimeOffRequestStatus
from .time_off_request_units import TimeOffRequestUnits


class TimeOffRequest(UncheckedBaseModel):
    """
    # The TimeOff Object
    ### Description
    The `TimeOff` object is used to represent all employees' Time Off entries.

    ### Usage Example
    Fetch from the `LIST TimeOffs` endpoint and filter by `ID` to show all time off requests.
    """

    employee: typing.Optional[TimeOffRequestEmployee] = pydantic.Field(default=None)
    """
    The employee requesting time off.
    """

    approver: typing.Optional[TimeOffRequestApprover] = pydantic.Field(default=None)
    """
    The Merge ID of the employee with the ability to approve the time off request.
    """

    status: typing.Optional[TimeOffRequestStatus] = pydantic.Field(default=None)
    """
    The status of this time off request.
    
    * `REQUESTED` - REQUESTED
    * `APPROVED` - APPROVED
    * `DECLINED` - DECLINED
    * `CANCELLED` - CANCELLED
    * `DELETED` - DELETED
    """

    employee_note: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee note for this time off request.
    """

    units: typing.Optional[TimeOffRequestUnits] = pydantic.Field(default=None)
    """
    The measurement that the third-party integration uses to count time requested.
    
    * `HOURS` - HOURS
    * `DAYS` - DAYS
    """

    amount: typing.Optional[float] = pydantic.Field(default=None)
    """
    The time off quantity measured by the prescribed “units”.
    """

    request_type: typing.Optional[TimeOffRequestRequestType] = pydantic.Field(default=None)
    """
    The type of time off request.
    
    * `VACATION` - VACATION
    * `SICK` - SICK
    * `PERSONAL` - PERSONAL
    * `JURY_DUTY` - JURY_DUTY
    * `VOLUNTEER` - VOLUNTEER
    * `BEREAVEMENT` - BEREAVEMENT
    """

    start_time: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The day and time of the start of the time requested off.
    """

    end_time: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The day and time of the end of the time requested off.
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .employee import Employee  # noqa: E402, F401, I001
from .employment import Employment  # noqa: E402, F401, I001
from .team import Team  # noqa: E402, F401, I001

update_forward_refs(TimeOffRequest)
