# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .remote_data import RemoteData
from .timesheet_entry_employee import TimesheetEntryEmployee


class TimesheetEntry(UncheckedBaseModel):
    """
    # The Timesheet Entry Object
    ### Description
    The `Timesheet Entry` object is used to track coverage for hours worked by an 'Employee'.


    ### Usage Example
    GET and POST Timesheet Entries
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    employee: typing.Optional[TimesheetEntryEmployee] = pydantic.Field(default=None)
    """
    The employee the timesheet entry is for.
    """

    hours_worked: typing.Optional[float] = pydantic.Field(default=None)
    """
    The number of hours logged by the employee.
    """

    start_time: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time at which the employee started work.
    """

    end_time: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time at which the employee ended work.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .employee import Employee  # noqa: E402, F401, I001
from .employment import Employment  # noqa: E402, F401, I001
from .team import Team  # noqa: E402, F401, I001

update_forward_refs(TimesheetEntry)
