# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.article import Article
from ...types.paginated_article_list import PaginatedArticleList
from .raw_client import AsyncRawArticlesClient, RawArticlesClient
from .types.articles_list_request_expand import ArticlesListRequestExpand
from .types.articles_list_request_type import ArticlesListRequestType
from .types.articles_retrieve_request_expand import ArticlesRetrieveRequestExpand


class ArticlesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawArticlesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawArticlesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawArticlesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[ArticlesListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        parent_article_id: typing.Optional[str] = None,
        parent_container_id: typing.Optional[str] = None,
        remote_id: typing.Optional[str] = None,
        root_container_id: typing.Optional[str] = None,
        status: typing.Optional[str] = None,
        type: typing.Optional[ArticlesListRequestType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedArticleList:
        """
        Returns a list of `Article` objects.

        Parameters
        ----------
        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[ArticlesListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        parent_article_id : typing.Optional[str]
            If provided, will only return sub articles of the parent_article_id.

        parent_container_id : typing.Optional[str]
            If provided, will only return sub articles of the parent_container_id.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        root_container_id : typing.Optional[str]
            If provided, will only return sub articles of the root_container_id.

        status : typing.Optional[str]
            If provided, will only return articles of the given status; multiple statuses can be separated by commas.

        type : typing.Optional[ArticlesListRequestType]
            If provided, will only return articles of the given type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedArticleList


        Examples
        --------
        import datetime

        from merge import Merge
        from merge.resources.knowledgebase.resources.articles import (
            ArticlesListRequestExpand,
            ArticlesListRequestType,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.knowledgebase.articles.list(
            created_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            created_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            expand=ArticlesListRequestExpand.ATTACHMENTS,
            include_deleted_data=True,
            include_remote_data=True,
            include_shell_data=True,
            modified_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            modified_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            page_size=1,
            parent_article_id="parent_article_id",
            parent_container_id="parent_container_id",
            remote_id="remote_id",
            root_container_id="root_container_id",
            status="status",
            type=ArticlesListRequestType.EMPTY,
        )
        """
        _response = self._raw_client.list(
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            parent_article_id=parent_article_id,
            parent_container_id=parent_container_id,
            remote_id=remote_id,
            root_container_id=root_container_id,
            status=status,
            type=type,
            request_options=request_options,
        )
        return _response.data

    def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[ArticlesRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Article:
        """
        Returns an `Article` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[ArticlesRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Article


        Examples
        --------
        from merge import Merge
        from merge.resources.knowledgebase.resources.articles import (
            ArticlesRetrieveRequestExpand,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.knowledgebase.articles.retrieve(
            id="id",
            expand=ArticlesRetrieveRequestExpand.ATTACHMENTS,
            include_remote_data=True,
            include_shell_data=True,
        )
        """
        _response = self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data


class AsyncArticlesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawArticlesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawArticlesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawArticlesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[ArticlesListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        parent_article_id: typing.Optional[str] = None,
        parent_container_id: typing.Optional[str] = None,
        remote_id: typing.Optional[str] = None,
        root_container_id: typing.Optional[str] = None,
        status: typing.Optional[str] = None,
        type: typing.Optional[ArticlesListRequestType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedArticleList:
        """
        Returns a list of `Article` objects.

        Parameters
        ----------
        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[ArticlesListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        parent_article_id : typing.Optional[str]
            If provided, will only return sub articles of the parent_article_id.

        parent_container_id : typing.Optional[str]
            If provided, will only return sub articles of the parent_container_id.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        root_container_id : typing.Optional[str]
            If provided, will only return sub articles of the root_container_id.

        status : typing.Optional[str]
            If provided, will only return articles of the given status; multiple statuses can be separated by commas.

        type : typing.Optional[ArticlesListRequestType]
            If provided, will only return articles of the given type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedArticleList


        Examples
        --------
        import asyncio
        import datetime

        from merge import AsyncMerge
        from merge.resources.knowledgebase.resources.articles import (
            ArticlesListRequestExpand,
            ArticlesListRequestType,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.knowledgebase.articles.list(
                created_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                created_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
                expand=ArticlesListRequestExpand.ATTACHMENTS,
                include_deleted_data=True,
                include_remote_data=True,
                include_shell_data=True,
                modified_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                modified_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                page_size=1,
                parent_article_id="parent_article_id",
                parent_container_id="parent_container_id",
                remote_id="remote_id",
                root_container_id="root_container_id",
                status="status",
                type=ArticlesListRequestType.EMPTY,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            parent_article_id=parent_article_id,
            parent_container_id=parent_container_id,
            remote_id=remote_id,
            root_container_id=root_container_id,
            status=status,
            type=type,
            request_options=request_options,
        )
        return _response.data

    async def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[ArticlesRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Article:
        """
        Returns an `Article` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[ArticlesRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Article


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.knowledgebase.resources.articles import (
            ArticlesRetrieveRequestExpand,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.knowledgebase.articles.retrieve(
                id="id",
                expand=ArticlesRetrieveRequestExpand.ATTACHMENTS,
                include_remote_data=True,
                include_shell_data=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data
