# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.issue import Issue
from ...types.paginated_issue_list import PaginatedIssueList
from .raw_client import AsyncRawIssuesClient, RawIssuesClient
from .types.issues_list_request_status import IssuesListRequestStatus


class IssuesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawIssuesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawIssuesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawIssuesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        account_token: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        end_user_organization_name: typing.Optional[str] = None,
        first_incident_time_after: typing.Optional[dt.datetime] = None,
        first_incident_time_before: typing.Optional[dt.datetime] = None,
        include_muted: typing.Optional[str] = None,
        integration_name: typing.Optional[str] = None,
        last_incident_time_after: typing.Optional[dt.datetime] = None,
        last_incident_time_before: typing.Optional[dt.datetime] = None,
        linked_account_id: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        start_date: typing.Optional[str] = None,
        status: typing.Optional[IssuesListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedIssueList:
        """
        Gets all issues for Organization.

        Parameters
        ----------
        account_token : typing.Optional[str]

        cursor : typing.Optional[str]
            The pagination cursor value.

        end_date : typing.Optional[str]
            If included, will only include issues whose most recent action occurred before this time

        end_user_organization_name : typing.Optional[str]

        first_incident_time_after : typing.Optional[dt.datetime]
            If provided, will only return issues whose first incident time was after this datetime.

        first_incident_time_before : typing.Optional[dt.datetime]
            If provided, will only return issues whose first incident time was before this datetime.

        include_muted : typing.Optional[str]
            If true, will include muted issues

        integration_name : typing.Optional[str]

        last_incident_time_after : typing.Optional[dt.datetime]
            If provided, will only return issues whose last incident time was after this datetime.

        last_incident_time_before : typing.Optional[dt.datetime]
            If provided, will only return issues whose last incident time was before this datetime.

        linked_account_id : typing.Optional[str]
            If provided, will only include issues pertaining to the linked account passed in.

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        start_date : typing.Optional[str]
            If included, will only include issues whose most recent action occurred after this time

        status : typing.Optional[IssuesListRequestStatus]
            Status of the issue. Options: ('ONGOING', 'RESOLVED')

            * `ONGOING` - ONGOING
            * `RESOLVED` - RESOLVED

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedIssueList


        Examples
        --------
        import datetime

        from merge import Merge
        from merge.resources.knowledgebase.resources.issues import (
            IssuesListRequestStatus,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.knowledgebase.issues.list(
            account_token="account_token",
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            end_date="end_date",
            end_user_organization_name="end_user_organization_name",
            first_incident_time_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            first_incident_time_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            include_muted="include_muted",
            integration_name="integration_name",
            last_incident_time_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            last_incident_time_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            linked_account_id="linked_account_id",
            page_size=1,
            start_date="start_date",
            status=IssuesListRequestStatus.ONGOING,
        )
        """
        _response = self._raw_client.list(
            account_token=account_token,
            cursor=cursor,
            end_date=end_date,
            end_user_organization_name=end_user_organization_name,
            first_incident_time_after=first_incident_time_after,
            first_incident_time_before=first_incident_time_before,
            include_muted=include_muted,
            integration_name=integration_name,
            last_incident_time_after=last_incident_time_after,
            last_incident_time_before=last_incident_time_before,
            linked_account_id=linked_account_id,
            page_size=page_size,
            start_date=start_date,
            status=status,
            request_options=request_options,
        )
        return _response.data

    def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Issue:
        """
        Get a specific issue.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Issue


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.knowledgebase.issues.retrieve(
            id="id",
        )
        """
        _response = self._raw_client.retrieve(id, request_options=request_options)
        return _response.data


class AsyncIssuesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawIssuesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawIssuesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawIssuesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        account_token: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        end_user_organization_name: typing.Optional[str] = None,
        first_incident_time_after: typing.Optional[dt.datetime] = None,
        first_incident_time_before: typing.Optional[dt.datetime] = None,
        include_muted: typing.Optional[str] = None,
        integration_name: typing.Optional[str] = None,
        last_incident_time_after: typing.Optional[dt.datetime] = None,
        last_incident_time_before: typing.Optional[dt.datetime] = None,
        linked_account_id: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        start_date: typing.Optional[str] = None,
        status: typing.Optional[IssuesListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedIssueList:
        """
        Gets all issues for Organization.

        Parameters
        ----------
        account_token : typing.Optional[str]

        cursor : typing.Optional[str]
            The pagination cursor value.

        end_date : typing.Optional[str]
            If included, will only include issues whose most recent action occurred before this time

        end_user_organization_name : typing.Optional[str]

        first_incident_time_after : typing.Optional[dt.datetime]
            If provided, will only return issues whose first incident time was after this datetime.

        first_incident_time_before : typing.Optional[dt.datetime]
            If provided, will only return issues whose first incident time was before this datetime.

        include_muted : typing.Optional[str]
            If true, will include muted issues

        integration_name : typing.Optional[str]

        last_incident_time_after : typing.Optional[dt.datetime]
            If provided, will only return issues whose last incident time was after this datetime.

        last_incident_time_before : typing.Optional[dt.datetime]
            If provided, will only return issues whose last incident time was before this datetime.

        linked_account_id : typing.Optional[str]
            If provided, will only include issues pertaining to the linked account passed in.

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        start_date : typing.Optional[str]
            If included, will only include issues whose most recent action occurred after this time

        status : typing.Optional[IssuesListRequestStatus]
            Status of the issue. Options: ('ONGOING', 'RESOLVED')

            * `ONGOING` - ONGOING
            * `RESOLVED` - RESOLVED

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedIssueList


        Examples
        --------
        import asyncio
        import datetime

        from merge import AsyncMerge
        from merge.resources.knowledgebase.resources.issues import (
            IssuesListRequestStatus,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.knowledgebase.issues.list(
                account_token="account_token",
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
                end_date="end_date",
                end_user_organization_name="end_user_organization_name",
                first_incident_time_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                first_incident_time_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                include_muted="include_muted",
                integration_name="integration_name",
                last_incident_time_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                last_incident_time_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                linked_account_id="linked_account_id",
                page_size=1,
                start_date="start_date",
                status=IssuesListRequestStatus.ONGOING,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            account_token=account_token,
            cursor=cursor,
            end_date=end_date,
            end_user_organization_name=end_user_organization_name,
            first_incident_time_after=first_incident_time_after,
            first_incident_time_before=first_incident_time_before,
            include_muted=include_muted,
            integration_name=integration_name,
            last_incident_time_after=last_incident_time_after,
            last_incident_time_before=last_incident_time_before,
            linked_account_id=linked_account_id,
            page_size=page_size,
            start_date=start_date,
            status=status,
            request_options=request_options,
        )
        return _response.data

    async def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Issue:
        """
        Get a specific issue.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Issue


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.knowledgebase.issues.retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(id, request_options=request_options)
        return _response.data
