# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .article_attachments_item import ArticleAttachmentsItem
from .article_author import ArticleAuthor
from .article_last_edited_by import ArticleLastEditedBy
from .article_parent_container import ArticleParentContainer
from .article_permissions_item import ArticlePermissionsItem
from .article_root_container import ArticleRootContainer
from .article_status import ArticleStatus
from .article_type import ArticleType
from .article_visibility import ArticleVisibility
from .remote_data import RemoteData


class Article(UncheckedBaseModel):
    """
    # The Article Object
    ### Description
    The `Article` object is used to represent a form of content in the knowledge base, such as an article or page.
    ### Usage Example
    Fetch from the `GET /api/knowledgebase/v1/articles` endpoint and view their articles.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title of the article.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the article.
    """

    author: typing.Optional[ArticleAuthor] = pydantic.Field(default=None)
    """
    The user who created the article.
    """

    last_edited_by: typing.Optional[ArticleLastEditedBy] = pydantic.Field(default=None)
    """
    The user to last update the article.
    """

    visibility: typing.Optional[ArticleVisibility] = pydantic.Field(default=None)
    """
    The visibility of the article.
    
    * `PUBLIC` - PUBLIC
    * `INTERNAL` - INTERNAL
    * `RESTRICTED` - RESTRICTED
    """

    article_content_download_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The presigned S3 URL to fetch article content.
    """

    checksum: typing.Optional[str] = pydantic.Field(default=None)
    """
    The SHA256 checksum of the article content.
    """

    article_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL to the webpage of the article.
    """

    status: typing.Optional[ArticleStatus] = pydantic.Field(default=None)
    """
    The status of the article.
    
    * `DRAFT` - DRAFT
    * `PUBLISHED` - PUBLISHED
    * `ARCHIVED` - ARCHIVED
    * `TRASH` - TRASH
    """

    type: typing.Optional[ArticleType] = pydantic.Field(default=None)
    """
    The type of the article.
    
    * `PAGE` - PAGE
    * `BLOG_POST` - BLOG_POST
    * `SMART_LINK` - SMART_LINK
    """

    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's article was created.
    """

    remote_updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's article was updated.
    """

    parent_article: typing.Optional["ArticleParentArticle"] = pydantic.Field(default=None)
    """
    The parent article an article is nested within.
    """

    parent_container: typing.Optional[ArticleParentContainer] = pydantic.Field(default=None)
    """
    The parent container an article is nested within.
    """

    root_container: typing.Optional[ArticleRootContainer] = pydantic.Field(default=None)
    """
    The top-level container in the hierarchy that holds this article. This will reference a container object that will typically be a SPACE or WORKSPACE type.
    """

    permissions: typing.Optional[typing.List[ArticlePermissionsItem]] = None
    attachments: typing.Optional[typing.List[typing.Optional[ArticleAttachmentsItem]]] = None
    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .group import Group  # noqa: E402, F401, I001
from .article_parent_article import ArticleParentArticle  # noqa: E402, F401, I001

update_forward_refs(Article)
