# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .permission_group import PermissionGroup
from .permission_type import PermissionType
from .permission_user import PermissionUser
from .roles_enum import RolesEnum


class Permission(UncheckedBaseModel):
    """
    # The Permission Object
    ### Description
    The `Permission` object is used to represent a user's or group's access to an article or container. Permissions are unexpanded by default.
    ### Usage Example
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    user: typing.Optional[PermissionUser] = None
    group: typing.Optional[PermissionGroup] = None
    type: typing.Optional[PermissionType] = pydantic.Field(default=None)
    """
    Denotes what type of people have access to the Article or Container.
    
    * `USER` - USER
    * `GROUP` - GROUP
    * `COMPANY` - COMPANY
    * `ANYONE` - ANYONE
    """

    roles: typing.Optional[typing.List[typing.Optional[RolesEnum]]] = pydantic.Field(default=None)
    """
    The permissions that the user or group has for the Article or Container. It is possible for a user or group to have multiple roles, such as viewing & uploading.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .group import Group  # noqa: E402, F401, I001

update_forward_refs(Permission)
