# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawTicketingClient, RawTicketingClient

if typing.TYPE_CHECKING:
    from .resources.account_details.client import AccountDetailsClient, AsyncAccountDetailsClient
    from .resources.account_token.client import AccountTokenClient, AsyncAccountTokenClient
    from .resources.accounts.client import AccountsClient, AsyncAccountsClient
    from .resources.async_passthrough.client import AsyncAsyncPassthroughClient
    from .resources.async_passthrough.client import (
        AsyncPassthroughClient as resources_ticketing_resources_async_passthrough_client_AsyncPassthroughClient,
    )
    from .resources.attachments.client import AsyncAttachmentsClient, AttachmentsClient
    from .resources.audit_trail.client import AsyncAuditTrailClient, AuditTrailClient
    from .resources.available_actions.client import AsyncAvailableActionsClient, AvailableActionsClient
    from .resources.collections.client import AsyncCollectionsClient, CollectionsClient
    from .resources.comments.client import AsyncCommentsClient, CommentsClient
    from .resources.contacts.client import AsyncContactsClient, ContactsClient
    from .resources.delete_account.client import AsyncDeleteAccountClient, DeleteAccountClient
    from .resources.field_mapping.client import AsyncFieldMappingClient, FieldMappingClient
    from .resources.force_resync.client import AsyncForceResyncClient, ForceResyncClient
    from .resources.generate_key.client import AsyncGenerateKeyClient, GenerateKeyClient
    from .resources.issues.client import AsyncIssuesClient, IssuesClient
    from .resources.link_token.client import AsyncLinkTokenClient, LinkTokenClient
    from .resources.linked_accounts.client import AsyncLinkedAccountsClient, LinkedAccountsClient
    from .resources.passthrough.client import (
        AsyncPassthroughClient as resources_ticketing_resources_passthrough_client_AsyncPassthroughClient,
    )
    from .resources.passthrough.client import PassthroughClient
    from .resources.projects.client import AsyncProjectsClient, ProjectsClient
    from .resources.regenerate_key.client import AsyncRegenerateKeyClient, RegenerateKeyClient
    from .resources.roles.client import AsyncRolesClient, RolesClient
    from .resources.scopes.client import AsyncScopesClient, ScopesClient
    from .resources.sync_status.client import AsyncSyncStatusClient, SyncStatusClient
    from .resources.tags.client import AsyncTagsClient, TagsClient
    from .resources.teams.client import AsyncTeamsClient, TeamsClient
    from .resources.tickets.client import AsyncTicketsClient, TicketsClient
    from .resources.users.client import AsyncUsersClient, UsersClient
    from .resources.webhook_receivers.client import AsyncWebhookReceiversClient, WebhookReceiversClient


class TicketingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTicketingClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._account_details: typing.Optional[AccountDetailsClient] = None
        self._account_token: typing.Optional[AccountTokenClient] = None
        self._accounts: typing.Optional[AccountsClient] = None
        self._async_passthrough: typing.Optional[
            resources_ticketing_resources_async_passthrough_client_AsyncPassthroughClient
        ] = None
        self._attachments: typing.Optional[AttachmentsClient] = None
        self._audit_trail: typing.Optional[AuditTrailClient] = None
        self._available_actions: typing.Optional[AvailableActionsClient] = None
        self._collections: typing.Optional[CollectionsClient] = None
        self._comments: typing.Optional[CommentsClient] = None
        self._contacts: typing.Optional[ContactsClient] = None
        self._scopes: typing.Optional[ScopesClient] = None
        self._delete_account: typing.Optional[DeleteAccountClient] = None
        self._field_mapping: typing.Optional[FieldMappingClient] = None
        self._generate_key: typing.Optional[GenerateKeyClient] = None
        self._issues: typing.Optional[IssuesClient] = None
        self._link_token: typing.Optional[LinkTokenClient] = None
        self._linked_accounts: typing.Optional[LinkedAccountsClient] = None
        self._passthrough: typing.Optional[PassthroughClient] = None
        self._projects: typing.Optional[ProjectsClient] = None
        self._regenerate_key: typing.Optional[RegenerateKeyClient] = None
        self._roles: typing.Optional[RolesClient] = None
        self._sync_status: typing.Optional[SyncStatusClient] = None
        self._force_resync: typing.Optional[ForceResyncClient] = None
        self._tags: typing.Optional[TagsClient] = None
        self._teams: typing.Optional[TeamsClient] = None
        self._tickets: typing.Optional[TicketsClient] = None
        self._users: typing.Optional[UsersClient] = None
        self._webhook_receivers: typing.Optional[WebhookReceiversClient] = None

    @property
    def with_raw_response(self) -> RawTicketingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTicketingClient
        """
        return self._raw_client

    @property
    def account_details(self):
        if self._account_details is None:
            from .resources.account_details.client import AccountDetailsClient  # noqa: E402

            self._account_details = AccountDetailsClient(client_wrapper=self._client_wrapper)
        return self._account_details

    @property
    def account_token(self):
        if self._account_token is None:
            from .resources.account_token.client import AccountTokenClient  # noqa: E402

            self._account_token = AccountTokenClient(client_wrapper=self._client_wrapper)
        return self._account_token

    @property
    def accounts(self):
        if self._accounts is None:
            from .resources.accounts.client import AccountsClient  # noqa: E402

            self._accounts = AccountsClient(client_wrapper=self._client_wrapper)
        return self._accounts

    @property
    def async_passthrough(self):
        if self._async_passthrough is None:
            from .resources.async_passthrough.client import (
                AsyncPassthroughClient as resources_ticketing_resources_async_passthrough_client_AsyncPassthroughClient,  # noqa: E402
            )

            self._async_passthrough = resources_ticketing_resources_async_passthrough_client_AsyncPassthroughClient(
                client_wrapper=self._client_wrapper
            )
        return self._async_passthrough

    @property
    def attachments(self):
        if self._attachments is None:
            from .resources.attachments.client import AttachmentsClient  # noqa: E402

            self._attachments = AttachmentsClient(client_wrapper=self._client_wrapper)
        return self._attachments

    @property
    def audit_trail(self):
        if self._audit_trail is None:
            from .resources.audit_trail.client import AuditTrailClient  # noqa: E402

            self._audit_trail = AuditTrailClient(client_wrapper=self._client_wrapper)
        return self._audit_trail

    @property
    def available_actions(self):
        if self._available_actions is None:
            from .resources.available_actions.client import AvailableActionsClient  # noqa: E402

            self._available_actions = AvailableActionsClient(client_wrapper=self._client_wrapper)
        return self._available_actions

    @property
    def collections(self):
        if self._collections is None:
            from .resources.collections.client import CollectionsClient  # noqa: E402

            self._collections = CollectionsClient(client_wrapper=self._client_wrapper)
        return self._collections

    @property
    def comments(self):
        if self._comments is None:
            from .resources.comments.client import CommentsClient  # noqa: E402

            self._comments = CommentsClient(client_wrapper=self._client_wrapper)
        return self._comments

    @property
    def contacts(self):
        if self._contacts is None:
            from .resources.contacts.client import ContactsClient  # noqa: E402

            self._contacts = ContactsClient(client_wrapper=self._client_wrapper)
        return self._contacts

    @property
    def scopes(self):
        if self._scopes is None:
            from .resources.scopes.client import ScopesClient  # noqa: E402

            self._scopes = ScopesClient(client_wrapper=self._client_wrapper)
        return self._scopes

    @property
    def delete_account(self):
        if self._delete_account is None:
            from .resources.delete_account.client import DeleteAccountClient  # noqa: E402

            self._delete_account = DeleteAccountClient(client_wrapper=self._client_wrapper)
        return self._delete_account

    @property
    def field_mapping(self):
        if self._field_mapping is None:
            from .resources.field_mapping.client import FieldMappingClient  # noqa: E402

            self._field_mapping = FieldMappingClient(client_wrapper=self._client_wrapper)
        return self._field_mapping

    @property
    def generate_key(self):
        if self._generate_key is None:
            from .resources.generate_key.client import GenerateKeyClient  # noqa: E402

            self._generate_key = GenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._generate_key

    @property
    def issues(self):
        if self._issues is None:
            from .resources.issues.client import IssuesClient  # noqa: E402

            self._issues = IssuesClient(client_wrapper=self._client_wrapper)
        return self._issues

    @property
    def link_token(self):
        if self._link_token is None:
            from .resources.link_token.client import LinkTokenClient  # noqa: E402

            self._link_token = LinkTokenClient(client_wrapper=self._client_wrapper)
        return self._link_token

    @property
    def linked_accounts(self):
        if self._linked_accounts is None:
            from .resources.linked_accounts.client import LinkedAccountsClient  # noqa: E402

            self._linked_accounts = LinkedAccountsClient(client_wrapper=self._client_wrapper)
        return self._linked_accounts

    @property
    def passthrough(self):
        if self._passthrough is None:
            from .resources.passthrough.client import PassthroughClient  # noqa: E402

            self._passthrough = PassthroughClient(client_wrapper=self._client_wrapper)
        return self._passthrough

    @property
    def projects(self):
        if self._projects is None:
            from .resources.projects.client import ProjectsClient  # noqa: E402

            self._projects = ProjectsClient(client_wrapper=self._client_wrapper)
        return self._projects

    @property
    def regenerate_key(self):
        if self._regenerate_key is None:
            from .resources.regenerate_key.client import RegenerateKeyClient  # noqa: E402

            self._regenerate_key = RegenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._regenerate_key

    @property
    def roles(self):
        if self._roles is None:
            from .resources.roles.client import RolesClient  # noqa: E402

            self._roles = RolesClient(client_wrapper=self._client_wrapper)
        return self._roles

    @property
    def sync_status(self):
        if self._sync_status is None:
            from .resources.sync_status.client import SyncStatusClient  # noqa: E402

            self._sync_status = SyncStatusClient(client_wrapper=self._client_wrapper)
        return self._sync_status

    @property
    def force_resync(self):
        if self._force_resync is None:
            from .resources.force_resync.client import ForceResyncClient  # noqa: E402

            self._force_resync = ForceResyncClient(client_wrapper=self._client_wrapper)
        return self._force_resync

    @property
    def tags(self):
        if self._tags is None:
            from .resources.tags.client import TagsClient  # noqa: E402

            self._tags = TagsClient(client_wrapper=self._client_wrapper)
        return self._tags

    @property
    def teams(self):
        if self._teams is None:
            from .resources.teams.client import TeamsClient  # noqa: E402

            self._teams = TeamsClient(client_wrapper=self._client_wrapper)
        return self._teams

    @property
    def tickets(self):
        if self._tickets is None:
            from .resources.tickets.client import TicketsClient  # noqa: E402

            self._tickets = TicketsClient(client_wrapper=self._client_wrapper)
        return self._tickets

    @property
    def users(self):
        if self._users is None:
            from .resources.users.client import UsersClient  # noqa: E402

            self._users = UsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def webhook_receivers(self):
        if self._webhook_receivers is None:
            from .resources.webhook_receivers.client import WebhookReceiversClient  # noqa: E402

            self._webhook_receivers = WebhookReceiversClient(client_wrapper=self._client_wrapper)
        return self._webhook_receivers


class AsyncTicketingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTicketingClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._account_details: typing.Optional[AsyncAccountDetailsClient] = None
        self._account_token: typing.Optional[AsyncAccountTokenClient] = None
        self._accounts: typing.Optional[AsyncAccountsClient] = None
        self._async_passthrough: typing.Optional[AsyncAsyncPassthroughClient] = None
        self._attachments: typing.Optional[AsyncAttachmentsClient] = None
        self._audit_trail: typing.Optional[AsyncAuditTrailClient] = None
        self._available_actions: typing.Optional[AsyncAvailableActionsClient] = None
        self._collections: typing.Optional[AsyncCollectionsClient] = None
        self._comments: typing.Optional[AsyncCommentsClient] = None
        self._contacts: typing.Optional[AsyncContactsClient] = None
        self._scopes: typing.Optional[AsyncScopesClient] = None
        self._delete_account: typing.Optional[AsyncDeleteAccountClient] = None
        self._field_mapping: typing.Optional[AsyncFieldMappingClient] = None
        self._generate_key: typing.Optional[AsyncGenerateKeyClient] = None
        self._issues: typing.Optional[AsyncIssuesClient] = None
        self._link_token: typing.Optional[AsyncLinkTokenClient] = None
        self._linked_accounts: typing.Optional[AsyncLinkedAccountsClient] = None
        self._passthrough: typing.Optional[resources_ticketing_resources_passthrough_client_AsyncPassthroughClient] = (
            None
        )
        self._projects: typing.Optional[AsyncProjectsClient] = None
        self._regenerate_key: typing.Optional[AsyncRegenerateKeyClient] = None
        self._roles: typing.Optional[AsyncRolesClient] = None
        self._sync_status: typing.Optional[AsyncSyncStatusClient] = None
        self._force_resync: typing.Optional[AsyncForceResyncClient] = None
        self._tags: typing.Optional[AsyncTagsClient] = None
        self._teams: typing.Optional[AsyncTeamsClient] = None
        self._tickets: typing.Optional[AsyncTicketsClient] = None
        self._users: typing.Optional[AsyncUsersClient] = None
        self._webhook_receivers: typing.Optional[AsyncWebhookReceiversClient] = None

    @property
    def with_raw_response(self) -> AsyncRawTicketingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTicketingClient
        """
        return self._raw_client

    @property
    def account_details(self):
        if self._account_details is None:
            from .resources.account_details.client import AsyncAccountDetailsClient  # noqa: E402

            self._account_details = AsyncAccountDetailsClient(client_wrapper=self._client_wrapper)
        return self._account_details

    @property
    def account_token(self):
        if self._account_token is None:
            from .resources.account_token.client import AsyncAccountTokenClient  # noqa: E402

            self._account_token = AsyncAccountTokenClient(client_wrapper=self._client_wrapper)
        return self._account_token

    @property
    def accounts(self):
        if self._accounts is None:
            from .resources.accounts.client import AsyncAccountsClient  # noqa: E402

            self._accounts = AsyncAccountsClient(client_wrapper=self._client_wrapper)
        return self._accounts

    @property
    def async_passthrough(self):
        if self._async_passthrough is None:
            from .resources.async_passthrough.client import AsyncAsyncPassthroughClient  # noqa: E402

            self._async_passthrough = AsyncAsyncPassthroughClient(client_wrapper=self._client_wrapper)
        return self._async_passthrough

    @property
    def attachments(self):
        if self._attachments is None:
            from .resources.attachments.client import AsyncAttachmentsClient  # noqa: E402

            self._attachments = AsyncAttachmentsClient(client_wrapper=self._client_wrapper)
        return self._attachments

    @property
    def audit_trail(self):
        if self._audit_trail is None:
            from .resources.audit_trail.client import AsyncAuditTrailClient  # noqa: E402

            self._audit_trail = AsyncAuditTrailClient(client_wrapper=self._client_wrapper)
        return self._audit_trail

    @property
    def available_actions(self):
        if self._available_actions is None:
            from .resources.available_actions.client import AsyncAvailableActionsClient  # noqa: E402

            self._available_actions = AsyncAvailableActionsClient(client_wrapper=self._client_wrapper)
        return self._available_actions

    @property
    def collections(self):
        if self._collections is None:
            from .resources.collections.client import AsyncCollectionsClient  # noqa: E402

            self._collections = AsyncCollectionsClient(client_wrapper=self._client_wrapper)
        return self._collections

    @property
    def comments(self):
        if self._comments is None:
            from .resources.comments.client import AsyncCommentsClient  # noqa: E402

            self._comments = AsyncCommentsClient(client_wrapper=self._client_wrapper)
        return self._comments

    @property
    def contacts(self):
        if self._contacts is None:
            from .resources.contacts.client import AsyncContactsClient  # noqa: E402

            self._contacts = AsyncContactsClient(client_wrapper=self._client_wrapper)
        return self._contacts

    @property
    def scopes(self):
        if self._scopes is None:
            from .resources.scopes.client import AsyncScopesClient  # noqa: E402

            self._scopes = AsyncScopesClient(client_wrapper=self._client_wrapper)
        return self._scopes

    @property
    def delete_account(self):
        if self._delete_account is None:
            from .resources.delete_account.client import AsyncDeleteAccountClient  # noqa: E402

            self._delete_account = AsyncDeleteAccountClient(client_wrapper=self._client_wrapper)
        return self._delete_account

    @property
    def field_mapping(self):
        if self._field_mapping is None:
            from .resources.field_mapping.client import AsyncFieldMappingClient  # noqa: E402

            self._field_mapping = AsyncFieldMappingClient(client_wrapper=self._client_wrapper)
        return self._field_mapping

    @property
    def generate_key(self):
        if self._generate_key is None:
            from .resources.generate_key.client import AsyncGenerateKeyClient  # noqa: E402

            self._generate_key = AsyncGenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._generate_key

    @property
    def issues(self):
        if self._issues is None:
            from .resources.issues.client import AsyncIssuesClient  # noqa: E402

            self._issues = AsyncIssuesClient(client_wrapper=self._client_wrapper)
        return self._issues

    @property
    def link_token(self):
        if self._link_token is None:
            from .resources.link_token.client import AsyncLinkTokenClient  # noqa: E402

            self._link_token = AsyncLinkTokenClient(client_wrapper=self._client_wrapper)
        return self._link_token

    @property
    def linked_accounts(self):
        if self._linked_accounts is None:
            from .resources.linked_accounts.client import AsyncLinkedAccountsClient  # noqa: E402

            self._linked_accounts = AsyncLinkedAccountsClient(client_wrapper=self._client_wrapper)
        return self._linked_accounts

    @property
    def passthrough(self):
        if self._passthrough is None:
            from .resources.passthrough.client import (
                AsyncPassthroughClient as resources_ticketing_resources_passthrough_client_AsyncPassthroughClient,  # noqa: E402
            )

            self._passthrough = resources_ticketing_resources_passthrough_client_AsyncPassthroughClient(
                client_wrapper=self._client_wrapper
            )
        return self._passthrough

    @property
    def projects(self):
        if self._projects is None:
            from .resources.projects.client import AsyncProjectsClient  # noqa: E402

            self._projects = AsyncProjectsClient(client_wrapper=self._client_wrapper)
        return self._projects

    @property
    def regenerate_key(self):
        if self._regenerate_key is None:
            from .resources.regenerate_key.client import AsyncRegenerateKeyClient  # noqa: E402

            self._regenerate_key = AsyncRegenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._regenerate_key

    @property
    def roles(self):
        if self._roles is None:
            from .resources.roles.client import AsyncRolesClient  # noqa: E402

            self._roles = AsyncRolesClient(client_wrapper=self._client_wrapper)
        return self._roles

    @property
    def sync_status(self):
        if self._sync_status is None:
            from .resources.sync_status.client import AsyncSyncStatusClient  # noqa: E402

            self._sync_status = AsyncSyncStatusClient(client_wrapper=self._client_wrapper)
        return self._sync_status

    @property
    def force_resync(self):
        if self._force_resync is None:
            from .resources.force_resync.client import AsyncForceResyncClient  # noqa: E402

            self._force_resync = AsyncForceResyncClient(client_wrapper=self._client_wrapper)
        return self._force_resync

    @property
    def tags(self):
        if self._tags is None:
            from .resources.tags.client import AsyncTagsClient  # noqa: E402

            self._tags = AsyncTagsClient(client_wrapper=self._client_wrapper)
        return self._tags

    @property
    def teams(self):
        if self._teams is None:
            from .resources.teams.client import AsyncTeamsClient  # noqa: E402

            self._teams = AsyncTeamsClient(client_wrapper=self._client_wrapper)
        return self._teams

    @property
    def tickets(self):
        if self._tickets is None:
            from .resources.tickets.client import AsyncTicketsClient  # noqa: E402

            self._tickets = AsyncTicketsClient(client_wrapper=self._client_wrapper)
        return self._tickets

    @property
    def users(self):
        if self._users is None:
            from .resources.users.client import AsyncUsersClient  # noqa: E402

            self._users = AsyncUsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def webhook_receivers(self):
        if self._webhook_receivers is None:
            from .resources.webhook_receivers.client import AsyncWebhookReceiversClient  # noqa: E402

            self._webhook_receivers = AsyncWebhookReceiversClient(client_wrapper=self._client_wrapper)
        return self._webhook_receivers
