# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.sync_status import SyncStatus
from .raw_client import AsyncRawForceResyncClient, RawForceResyncClient


class ForceResyncClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawForceResyncClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawForceResyncClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawForceResyncClient
        """
        return self._raw_client

    def sync_status_resync_create(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SyncStatus]:
        """
        Force re-sync of all models. This endpoint is available for monthly, quarterly, and highest sync frequency customers on the Professional or Enterprise plans. Doing so will consume a sync credit for the relevant linked account. Force re-syncs can also be triggered manually in the Merge Dashboard and is available for all customers.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SyncStatus]


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ticketing.force_resync.sync_status_resync_create()
        """
        _response = self._raw_client.sync_status_resync_create(request_options=request_options)
        return _response.data


class AsyncForceResyncClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawForceResyncClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawForceResyncClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawForceResyncClient
        """
        return self._raw_client

    async def sync_status_resync_create(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SyncStatus]:
        """
        Force re-sync of all models. This endpoint is available for monthly, quarterly, and highest sync frequency customers on the Professional or Enterprise plans. Doing so will consume a sync credit for the relevant linked account. Force re-syncs can also be triggered manually in the Merge Dashboard and is available for all customers.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SyncStatus]


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ticketing.force_resync.sync_status_resync_create()


        asyncio.run(main())
        """
        _response = await self._raw_client.sync_status_resync_create(request_options=request_options)
        return _response.data
