# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.meta_response import MetaResponse
from ...types.paginated_remote_field_class_list import PaginatedRemoteFieldClassList
from ...types.paginated_ticket_list import PaginatedTicketList
from ...types.paginated_viewer_list import PaginatedViewerList
from ...types.patched_ticket_request import PatchedTicketRequest
from ...types.ticket import Ticket
from ...types.ticket_request import TicketRequest
from ...types.ticket_response import TicketResponse
from .raw_client import AsyncRawTicketsClient, RawTicketsClient
from .types.tickets_list_request_expand import TicketsListRequestExpand
from .types.tickets_list_request_priority import TicketsListRequestPriority
from .types.tickets_list_request_remote_fields import TicketsListRequestRemoteFields
from .types.tickets_list_request_show_enum_origins import TicketsListRequestShowEnumOrigins
from .types.tickets_list_request_status import TicketsListRequestStatus
from .types.tickets_retrieve_request_expand import TicketsRetrieveRequestExpand
from .types.tickets_retrieve_request_remote_fields import TicketsRetrieveRequestRemoteFields
from .types.tickets_retrieve_request_show_enum_origins import TicketsRetrieveRequestShowEnumOrigins
from .types.tickets_viewers_list_request_expand import TicketsViewersListRequestExpand

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TicketsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTicketsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTicketsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTicketsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        account_id: typing.Optional[str] = None,
        assignee_ids: typing.Optional[str] = None,
        collection_ids: typing.Optional[str] = None,
        completed_after: typing.Optional[dt.datetime] = None,
        completed_before: typing.Optional[dt.datetime] = None,
        contact_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        creator_id: typing.Optional[str] = None,
        creator_ids: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        due_after: typing.Optional[dt.datetime] = None,
        due_before: typing.Optional[dt.datetime] = None,
        expand: typing.Optional[TicketsListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        name: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        parent_ticket_id: typing.Optional[str] = None,
        priority: typing.Optional[TicketsListRequestPriority] = None,
        remote_created_after: typing.Optional[dt.datetime] = None,
        remote_created_before: typing.Optional[dt.datetime] = None,
        remote_fields: typing.Optional[TicketsListRequestRemoteFields] = None,
        remote_id: typing.Optional[str] = None,
        remote_updated_after: typing.Optional[dt.datetime] = None,
        remote_updated_before: typing.Optional[dt.datetime] = None,
        show_enum_origins: typing.Optional[TicketsListRequestShowEnumOrigins] = None,
        status: typing.Optional[TicketsListRequestStatus] = None,
        tags: typing.Optional[str] = None,
        ticket_type: typing.Optional[str] = None,
        ticket_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedTicketList:
        """
        Returns a list of `Ticket` objects.

        Parameters
        ----------
        account_id : typing.Optional[str]
            If provided, will only return tickets for this account.

        assignee_ids : typing.Optional[str]
            If provided, will only return tickets assigned to the assignee_ids; multiple assignee_ids can be separated by commas.

        collection_ids : typing.Optional[str]
            If provided, will only return tickets assigned to the collection_ids; multiple collection_ids can be separated by commas.

        completed_after : typing.Optional[dt.datetime]
            If provided, will only return tickets completed after this datetime.

        completed_before : typing.Optional[dt.datetime]
            If provided, will only return tickets completed before this datetime.

        contact_id : typing.Optional[str]
            If provided, will only return tickets for this contact.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        creator_id : typing.Optional[str]
            If provided, will only return tickets created by this creator_id.

        creator_ids : typing.Optional[str]
            If provided, will only return tickets created by the creator_ids; multiple creator_ids can be separated by commas.

        cursor : typing.Optional[str]
            The pagination cursor value.

        due_after : typing.Optional[dt.datetime]
            If provided, will only return tickets due after this datetime.

        due_before : typing.Optional[dt.datetime]
            If provided, will only return tickets due before this datetime.

        expand : typing.Optional[TicketsListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        name : typing.Optional[str]
            If provided, will only return tickets with this name.

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        parent_ticket_id : typing.Optional[str]
            If provided, will only return sub tickets of the parent_ticket_id.

        priority : typing.Optional[TicketsListRequestPriority]
            If provided, will only return tickets of this priority.

            * `URGENT` - URGENT
            * `HIGH` - HIGH
            * `NORMAL` - NORMAL
            * `LOW` - LOW

        remote_created_after : typing.Optional[dt.datetime]
            If provided, will only return tickets created in the third party platform after this datetime.

        remote_created_before : typing.Optional[dt.datetime]
            If provided, will only return tickets created in the third party platform before this datetime.

        remote_fields : typing.Optional[TicketsListRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        remote_updated_after : typing.Optional[dt.datetime]
            If provided, will only return tickets updated in the third party platform after this datetime.

        remote_updated_before : typing.Optional[dt.datetime]
            If provided, will only return tickets updated in the third party platform before this datetime.

        show_enum_origins : typing.Optional[TicketsListRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        status : typing.Optional[TicketsListRequestStatus]
            If provided, will only return tickets of this status.

        tags : typing.Optional[str]
            If provided, will only return tickets matching the tags; multiple tags can be separated by commas.

        ticket_type : typing.Optional[str]
            If provided, will only return tickets of this type.

        ticket_url : typing.Optional[str]
            If provided, will only return tickets where the URL matches or contains the substring

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedTicketList


        Examples
        --------
        import datetime

        from merge import Merge
        from merge.resources.ticketing.resources.tickets import (
            TicketsListRequestExpand,
            TicketsListRequestPriority,
            TicketsListRequestRemoteFields,
            TicketsListRequestShowEnumOrigins,
            TicketsListRequestStatus,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ticketing.tickets.list(
            account_id="account_id",
            assignee_ids="assignee_ids",
            collection_ids="collection_ids",
            completed_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            completed_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            contact_id="contact_id",
            created_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            created_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            creator_id="creator_id",
            creator_ids="creator_ids",
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            due_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            due_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            expand=TicketsListRequestExpand.ACCOUNT,
            include_deleted_data=True,
            include_remote_data=True,
            include_remote_fields=True,
            include_shell_data=True,
            modified_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            modified_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            name="name",
            page_size=1,
            parent_ticket_id="parent_ticket_id",
            priority=TicketsListRequestPriority.HIGH,
            remote_created_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            remote_created_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            remote_fields=TicketsListRequestRemoteFields.PRIORITY,
            remote_id="remote_id",
            remote_updated_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            remote_updated_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            show_enum_origins=TicketsListRequestShowEnumOrigins.PRIORITY,
            status=TicketsListRequestStatus.EMPTY,
            tags="tags",
            ticket_type="ticket_type",
            ticket_url="ticket_url",
        )
        """
        _response = self._raw_client.list(
            account_id=account_id,
            assignee_ids=assignee_ids,
            collection_ids=collection_ids,
            completed_after=completed_after,
            completed_before=completed_before,
            contact_id=contact_id,
            created_after=created_after,
            created_before=created_before,
            creator_id=creator_id,
            creator_ids=creator_ids,
            cursor=cursor,
            due_after=due_after,
            due_before=due_before,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            name=name,
            page_size=page_size,
            parent_ticket_id=parent_ticket_id,
            priority=priority,
            remote_created_after=remote_created_after,
            remote_created_before=remote_created_before,
            remote_fields=remote_fields,
            remote_id=remote_id,
            remote_updated_after=remote_updated_after,
            remote_updated_before=remote_updated_before,
            show_enum_origins=show_enum_origins,
            status=status,
            tags=tags,
            ticket_type=ticket_type,
            ticket_url=ticket_url,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        model: TicketRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TicketResponse:
        """
        Creates a `Ticket` object with the given values.

        Parameters
        ----------
        model : TicketRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketResponse


        Examples
        --------
        from merge import Merge
        from merge.resources.ticketing import TicketRequest

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ticketing.tickets.create(
            is_debug_mode=True,
            run_async=True,
            model=TicketRequest(),
        )
        """
        _response = self._raw_client.create(
            model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[TicketsRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        remote_fields: typing.Optional[TicketsRetrieveRequestRemoteFields] = None,
        show_enum_origins: typing.Optional[TicketsRetrieveRequestShowEnumOrigins] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Ticket:
        """
        Returns a `Ticket` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[TicketsRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        remote_fields : typing.Optional[TicketsRetrieveRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        show_enum_origins : typing.Optional[TicketsRetrieveRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Ticket


        Examples
        --------
        from merge import Merge
        from merge.resources.ticketing.resources.tickets import (
            TicketsRetrieveRequestExpand,
            TicketsRetrieveRequestRemoteFields,
            TicketsRetrieveRequestShowEnumOrigins,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ticketing.tickets.retrieve(
            id="id",
            expand=TicketsRetrieveRequestExpand.ACCOUNT,
            include_remote_data=True,
            include_remote_fields=True,
            include_shell_data=True,
            remote_fields=TicketsRetrieveRequestRemoteFields.PRIORITY,
            show_enum_origins=TicketsRetrieveRequestShowEnumOrigins.PRIORITY,
        )
        """
        _response = self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            remote_fields=remote_fields,
            show_enum_origins=show_enum_origins,
            request_options=request_options,
        )
        return _response.data

    def partial_update(
        self,
        id: str,
        *,
        model: PatchedTicketRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TicketResponse:
        """
        Updates a `Ticket` object with the given `id`.

        Parameters
        ----------
        id : str

        model : PatchedTicketRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketResponse


        Examples
        --------
        from merge import Merge
        from merge.resources.ticketing import PatchedTicketRequest

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ticketing.tickets.partial_update(
            id="id",
            is_debug_mode=True,
            run_async=True,
            model=PatchedTicketRequest(),
        )
        """
        _response = self._raw_client.partial_update(
            id, model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    def viewers_list(
        self,
        ticket_id: str,
        *,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[TicketsViewersListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedViewerList:
        """
        Returns a list of `Viewer` objects that point to a User id or Team id that is either an assignee or viewer on a `Ticket` with the given id. [Learn more.](https://help.merge.dev/en/articles/10333658-ticketing-access-control-list-acls)

        Parameters
        ----------
        ticket_id : str

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[TicketsViewersListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedViewerList


        Examples
        --------
        from merge import Merge
        from merge.resources.ticketing.resources.tickets import (
            TicketsViewersListRequestExpand,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ticketing.tickets.viewers_list(
            ticket_id="ticket_id",
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            expand=TicketsViewersListRequestExpand.TEAM,
            include_deleted_data=True,
            include_remote_data=True,
            include_shell_data=True,
            page_size=1,
        )
        """
        _response = self._raw_client.viewers_list(
            ticket_id,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            page_size=page_size,
            request_options=request_options,
        )
        return _response.data

    def meta_patch_retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> MetaResponse:
        """
        Returns metadata for `Ticket` PATCHs.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ticketing.tickets.meta_patch_retrieve(
            id="id",
        )
        """
        _response = self._raw_client.meta_patch_retrieve(id, request_options=request_options)
        return _response.data

    def meta_post_retrieve(
        self,
        *,
        collection_id: typing.Optional[str] = None,
        ticket_type: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MetaResponse:
        """
        Returns metadata for `Ticket` POSTs.

        Parameters
        ----------
        collection_id : typing.Optional[str]
            If provided, will only return tickets for this collection.

        ticket_type : typing.Optional[str]
            If provided, will only return tickets for this ticket type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ticketing.tickets.meta_post_retrieve(
            collection_id="collection_id",
            ticket_type="ticket_type",
        )
        """
        _response = self._raw_client.meta_post_retrieve(
            collection_id=collection_id, ticket_type=ticket_type, request_options=request_options
        )
        return _response.data

    def remote_field_classes_list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        ids: typing.Optional[str] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        is_common_model_field: typing.Optional[bool] = None,
        is_custom: typing.Optional[bool] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedRemoteFieldClassList:
        """
        Returns a list of `RemoteFieldClass` objects.

        Parameters
        ----------
        cursor : typing.Optional[str]
            The pagination cursor value.

        ids : typing.Optional[str]
            If provided, will only return remote field classes with the `ids` in this list

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        is_common_model_field : typing.Optional[bool]
            If provided, will only return remote field classes with this is_common_model_field value

        is_custom : typing.Optional[bool]
            If provided, will only return remote fields classes with this is_custom value

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedRemoteFieldClassList


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ticketing.tickets.remote_field_classes_list(
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            ids="ids",
            include_deleted_data=True,
            include_remote_data=True,
            include_shell_data=True,
            is_common_model_field=True,
            is_custom=True,
            page_size=1,
        )
        """
        _response = self._raw_client.remote_field_classes_list(
            cursor=cursor,
            ids=ids,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            is_common_model_field=is_common_model_field,
            is_custom=is_custom,
            page_size=page_size,
            request_options=request_options,
        )
        return _response.data


class AsyncTicketsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTicketsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTicketsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTicketsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        account_id: typing.Optional[str] = None,
        assignee_ids: typing.Optional[str] = None,
        collection_ids: typing.Optional[str] = None,
        completed_after: typing.Optional[dt.datetime] = None,
        completed_before: typing.Optional[dt.datetime] = None,
        contact_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        creator_id: typing.Optional[str] = None,
        creator_ids: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        due_after: typing.Optional[dt.datetime] = None,
        due_before: typing.Optional[dt.datetime] = None,
        expand: typing.Optional[TicketsListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        name: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        parent_ticket_id: typing.Optional[str] = None,
        priority: typing.Optional[TicketsListRequestPriority] = None,
        remote_created_after: typing.Optional[dt.datetime] = None,
        remote_created_before: typing.Optional[dt.datetime] = None,
        remote_fields: typing.Optional[TicketsListRequestRemoteFields] = None,
        remote_id: typing.Optional[str] = None,
        remote_updated_after: typing.Optional[dt.datetime] = None,
        remote_updated_before: typing.Optional[dt.datetime] = None,
        show_enum_origins: typing.Optional[TicketsListRequestShowEnumOrigins] = None,
        status: typing.Optional[TicketsListRequestStatus] = None,
        tags: typing.Optional[str] = None,
        ticket_type: typing.Optional[str] = None,
        ticket_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedTicketList:
        """
        Returns a list of `Ticket` objects.

        Parameters
        ----------
        account_id : typing.Optional[str]
            If provided, will only return tickets for this account.

        assignee_ids : typing.Optional[str]
            If provided, will only return tickets assigned to the assignee_ids; multiple assignee_ids can be separated by commas.

        collection_ids : typing.Optional[str]
            If provided, will only return tickets assigned to the collection_ids; multiple collection_ids can be separated by commas.

        completed_after : typing.Optional[dt.datetime]
            If provided, will only return tickets completed after this datetime.

        completed_before : typing.Optional[dt.datetime]
            If provided, will only return tickets completed before this datetime.

        contact_id : typing.Optional[str]
            If provided, will only return tickets for this contact.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        creator_id : typing.Optional[str]
            If provided, will only return tickets created by this creator_id.

        creator_ids : typing.Optional[str]
            If provided, will only return tickets created by the creator_ids; multiple creator_ids can be separated by commas.

        cursor : typing.Optional[str]
            The pagination cursor value.

        due_after : typing.Optional[dt.datetime]
            If provided, will only return tickets due after this datetime.

        due_before : typing.Optional[dt.datetime]
            If provided, will only return tickets due before this datetime.

        expand : typing.Optional[TicketsListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        name : typing.Optional[str]
            If provided, will only return tickets with this name.

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        parent_ticket_id : typing.Optional[str]
            If provided, will only return sub tickets of the parent_ticket_id.

        priority : typing.Optional[TicketsListRequestPriority]
            If provided, will only return tickets of this priority.

            * `URGENT` - URGENT
            * `HIGH` - HIGH
            * `NORMAL` - NORMAL
            * `LOW` - LOW

        remote_created_after : typing.Optional[dt.datetime]
            If provided, will only return tickets created in the third party platform after this datetime.

        remote_created_before : typing.Optional[dt.datetime]
            If provided, will only return tickets created in the third party platform before this datetime.

        remote_fields : typing.Optional[TicketsListRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        remote_updated_after : typing.Optional[dt.datetime]
            If provided, will only return tickets updated in the third party platform after this datetime.

        remote_updated_before : typing.Optional[dt.datetime]
            If provided, will only return tickets updated in the third party platform before this datetime.

        show_enum_origins : typing.Optional[TicketsListRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        status : typing.Optional[TicketsListRequestStatus]
            If provided, will only return tickets of this status.

        tags : typing.Optional[str]
            If provided, will only return tickets matching the tags; multiple tags can be separated by commas.

        ticket_type : typing.Optional[str]
            If provided, will only return tickets of this type.

        ticket_url : typing.Optional[str]
            If provided, will only return tickets where the URL matches or contains the substring

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedTicketList


        Examples
        --------
        import asyncio
        import datetime

        from merge import AsyncMerge
        from merge.resources.ticketing.resources.tickets import (
            TicketsListRequestExpand,
            TicketsListRequestPriority,
            TicketsListRequestRemoteFields,
            TicketsListRequestShowEnumOrigins,
            TicketsListRequestStatus,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ticketing.tickets.list(
                account_id="account_id",
                assignee_ids="assignee_ids",
                collection_ids="collection_ids",
                completed_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                completed_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                contact_id="contact_id",
                created_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                created_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                creator_id="creator_id",
                creator_ids="creator_ids",
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
                due_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                due_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                expand=TicketsListRequestExpand.ACCOUNT,
                include_deleted_data=True,
                include_remote_data=True,
                include_remote_fields=True,
                include_shell_data=True,
                modified_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                modified_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                name="name",
                page_size=1,
                parent_ticket_id="parent_ticket_id",
                priority=TicketsListRequestPriority.HIGH,
                remote_created_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                remote_created_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                remote_fields=TicketsListRequestRemoteFields.PRIORITY,
                remote_id="remote_id",
                remote_updated_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                remote_updated_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                show_enum_origins=TicketsListRequestShowEnumOrigins.PRIORITY,
                status=TicketsListRequestStatus.EMPTY,
                tags="tags",
                ticket_type="ticket_type",
                ticket_url="ticket_url",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            account_id=account_id,
            assignee_ids=assignee_ids,
            collection_ids=collection_ids,
            completed_after=completed_after,
            completed_before=completed_before,
            contact_id=contact_id,
            created_after=created_after,
            created_before=created_before,
            creator_id=creator_id,
            creator_ids=creator_ids,
            cursor=cursor,
            due_after=due_after,
            due_before=due_before,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            name=name,
            page_size=page_size,
            parent_ticket_id=parent_ticket_id,
            priority=priority,
            remote_created_after=remote_created_after,
            remote_created_before=remote_created_before,
            remote_fields=remote_fields,
            remote_id=remote_id,
            remote_updated_after=remote_updated_after,
            remote_updated_before=remote_updated_before,
            show_enum_origins=show_enum_origins,
            status=status,
            tags=tags,
            ticket_type=ticket_type,
            ticket_url=ticket_url,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        model: TicketRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TicketResponse:
        """
        Creates a `Ticket` object with the given values.

        Parameters
        ----------
        model : TicketRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.ticketing import TicketRequest

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ticketing.tickets.create(
                is_debug_mode=True,
                run_async=True,
                model=TicketRequest(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    async def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[TicketsRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        remote_fields: typing.Optional[TicketsRetrieveRequestRemoteFields] = None,
        show_enum_origins: typing.Optional[TicketsRetrieveRequestShowEnumOrigins] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Ticket:
        """
        Returns a `Ticket` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[TicketsRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        remote_fields : typing.Optional[TicketsRetrieveRequestRemoteFields]
            Deprecated. Use show_enum_origins.

        show_enum_origins : typing.Optional[TicketsRetrieveRequestShowEnumOrigins]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Ticket


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.ticketing.resources.tickets import (
            TicketsRetrieveRequestExpand,
            TicketsRetrieveRequestRemoteFields,
            TicketsRetrieveRequestShowEnumOrigins,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ticketing.tickets.retrieve(
                id="id",
                expand=TicketsRetrieveRequestExpand.ACCOUNT,
                include_remote_data=True,
                include_remote_fields=True,
                include_shell_data=True,
                remote_fields=TicketsRetrieveRequestRemoteFields.PRIORITY,
                show_enum_origins=TicketsRetrieveRequestShowEnumOrigins.PRIORITY,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            remote_fields=remote_fields,
            show_enum_origins=show_enum_origins,
            request_options=request_options,
        )
        return _response.data

    async def partial_update(
        self,
        id: str,
        *,
        model: PatchedTicketRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TicketResponse:
        """
        Updates a `Ticket` object with the given `id`.

        Parameters
        ----------
        id : str

        model : PatchedTicketRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.ticketing import PatchedTicketRequest

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ticketing.tickets.partial_update(
                id="id",
                is_debug_mode=True,
                run_async=True,
                model=PatchedTicketRequest(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.partial_update(
            id, model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    async def viewers_list(
        self,
        ticket_id: str,
        *,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[TicketsViewersListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedViewerList:
        """
        Returns a list of `Viewer` objects that point to a User id or Team id that is either an assignee or viewer on a `Ticket` with the given id. [Learn more.](https://help.merge.dev/en/articles/10333658-ticketing-access-control-list-acls)

        Parameters
        ----------
        ticket_id : str

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[TicketsViewersListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedViewerList


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.ticketing.resources.tickets import (
            TicketsViewersListRequestExpand,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ticketing.tickets.viewers_list(
                ticket_id="ticket_id",
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
                expand=TicketsViewersListRequestExpand.TEAM,
                include_deleted_data=True,
                include_remote_data=True,
                include_shell_data=True,
                page_size=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.viewers_list(
            ticket_id,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            page_size=page_size,
            request_options=request_options,
        )
        return _response.data

    async def meta_patch_retrieve(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MetaResponse:
        """
        Returns metadata for `Ticket` PATCHs.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ticketing.tickets.meta_patch_retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.meta_patch_retrieve(id, request_options=request_options)
        return _response.data

    async def meta_post_retrieve(
        self,
        *,
        collection_id: typing.Optional[str] = None,
        ticket_type: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MetaResponse:
        """
        Returns metadata for `Ticket` POSTs.

        Parameters
        ----------
        collection_id : typing.Optional[str]
            If provided, will only return tickets for this collection.

        ticket_type : typing.Optional[str]
            If provided, will only return tickets for this ticket type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ticketing.tickets.meta_post_retrieve(
                collection_id="collection_id",
                ticket_type="ticket_type",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.meta_post_retrieve(
            collection_id=collection_id, ticket_type=ticket_type, request_options=request_options
        )
        return _response.data

    async def remote_field_classes_list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        ids: typing.Optional[str] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        is_common_model_field: typing.Optional[bool] = None,
        is_custom: typing.Optional[bool] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedRemoteFieldClassList:
        """
        Returns a list of `RemoteFieldClass` objects.

        Parameters
        ----------
        cursor : typing.Optional[str]
            The pagination cursor value.

        ids : typing.Optional[str]
            If provided, will only return remote field classes with the `ids` in this list

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        is_common_model_field : typing.Optional[bool]
            If provided, will only return remote field classes with this is_common_model_field value

        is_custom : typing.Optional[bool]
            If provided, will only return remote fields classes with this is_custom value

        page_size : typing.Optional[int]
            Number of results to return per page. The maximum limit is 100.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedRemoteFieldClassList


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ticketing.tickets.remote_field_classes_list(
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
                ids="ids",
                include_deleted_data=True,
                include_remote_data=True,
                include_shell_data=True,
                is_common_model_field=True,
                is_custom=True,
                page_size=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.remote_field_classes_list(
            cursor=cursor,
            ids=ids,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            is_common_model_field=is_common_model_field,
            is_custom=is_custom,
            page_size=page_size,
            request_options=request_options,
        )
        return _response.data
